/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base.lifecycle;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.software.base.lifecycle.NativeWindowsScriptRunner;
import org.apache.brooklyn.location.winrm.PlainWinRmExecTaskFactory;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.internal.AbstractSshExecTaskFactory;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmExecuteHelper {
    public static final Logger LOG = LoggerFactory.getLogger(WinRmExecuteHelper.class);
    private Task<Integer> task;
    protected final NativeWindowsScriptRunner runner;
    public final String summary;
    private String domain;
    private String command;
    private String psCommand;
    private Map<String, String> env;
    protected final Map flags = new LinkedHashMap();
    protected Predicate<? super Integer> resultCodeCheck = Predicates.alwaysTrue();
    protected ByteArrayOutputStream stdout;
    protected ByteArrayOutputStream stderr;
    protected ByteArrayOutputStream stdin;
    protected AbstractSshExecTaskFactory.Std2x2StreamProvider outStreams = null;
    protected Runnable mutexAcquire = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected Runnable mutexRelease = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected boolean gatherOutput = false;

    protected AbstractSshExecTaskFactory.Std2x2StreamProvider outStreams() {
        if (this.outStreams == null) {
            this.outStreams = new AbstractSshExecTaskFactory.Std2x2StreamProvider();
            this.outStreams.stdoutForReading = this.stdout;
            this.outStreams.stdoutForWriting = this.outStreams.stdoutForReading;
            this.outStreams.stderrForReading = this.stderr;
            this.outStreams.stderrForWriting = this.outStreams.stderrForReading;
        }
        return this.outStreams;
    }

    public WinRmExecuteHelper(NativeWindowsScriptRunner runner, String summary) {
        this.runner = runner;
        this.summary = summary;
    }

    public WinRmExecuteHelper setNtDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public WinRmExecuteHelper setCommand(String command) {
        this.command = command;
        return this;
    }

    public WinRmExecuteHelper setPsCommand(String psCommand) {
        this.psCommand = psCommand;
        return this;
    }

    public WinRmExecuteHelper setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public WinRmExecuteHelper useMutex(final WithMutexes mutexSupport, final String mutexId, final String description) {
        this.mutexAcquire = new Runnable(){

            @Override
            public void run() {
                mutexSupport.acquireMutex(mutexId, description);
            }
        };
        this.mutexRelease = new Runnable(){

            @Override
            public void run() {
                mutexSupport.releaseMutex(mutexId);
            }
        };
        return this;
    }

    @Beta
    public Task<Integer> queue() {
        return DynamicTasks.queueIfPossible(this.newTask()).orSubmitAndBlock().getTask();
    }

    public synchronized Task<Integer> newTask() {
        if (this.task != null) {
            throw new IllegalStateException("task can only be generated once");
        }
        TaskBuilder tb = Tasks.builder().displayName("winrm: " + this.summary).body((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return WinRmExecuteHelper.this.executeInternal();
            }
        });
        try {
            ByteArrayOutputStream stdin = new ByteArrayOutputStream();
            if (this.command != null) {
                stdin.write(this.command.getBytes());
            } else if (this.psCommand != null) {
                stdin.write(this.psCommand.getBytes());
            }
            tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)stdin));
        }
        catch (IOException e) {
            LOG.warn("Error registering stream stdin on " + tb + ": " + e, (Throwable)e);
        }
        Map flags = this.getFlags();
        Map env = (Map)flags.get("env");
        if (env != null) {
            tb.tag((Object)BrooklynTaskTags.tagForEnvStream((String)"env", (Map)env));
        }
        if (this.gatherOutput) {
            this.outStreams = PlainWinRmExecTaskFactory.newStreamProviderForWindowsXml((TaskBuilder)tb);
        }
        this.task = tb.build();
        return this.task;
    }

    public int execute() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            return (Integer)this.queue().getUnchecked();
        }
        return this.executeInternal();
    }

    public int executeInternal() {
        int result;
        this.mutexAcquire.run();
        try {
            if (this.gatherOutput) {
                if (this.outStreams().stdoutForWriting == null) {
                    this.outStreams().stdoutForReading = new ByteArrayOutputStream();
                    this.outStreams().stdoutForWriting = this.outStreams().stdoutForReading;
                }
                if (this.outStreams().stderrForWriting == null) {
                    this.outStreams().stderrForReading = new ByteArrayOutputStream();
                    this.outStreams().stderrForWriting = this.outStreams().stderrForReading;
                }
                this.flags.put("out", this.outStreams().stdoutForWriting);
                this.flags.put("err", this.outStreams().stderrForWriting);
            }
            this.flags.put(WinRmTool.COMPUTER_NAME, this.domain);
            if (this.env != null) {
                this.flags.put(WinRmTool.ENVIRONMENT, this.env);
            }
            if (!this.resultCodeCheck.apply((Object)(result = this.runner.executeNativeOrPsCommand(this.flags, this.command, this.psCommand, this.summary, false).intValue()))) {
                throw this.logWithDetailsAndThrow(String.format("Execution failed, invalid result %s for %s", result, this.summary), null);
            }
        }
        finally {
            this.mutexRelease.run();
        }
        return result;
    }

    public WinRmExecuteHelper failOnNonZeroResultCode() {
        return this.updateTaskAndFailOnNonZeroResultCode();
    }

    public WinRmExecuteHelper updateTaskAndFailOnNonZeroResultCode() {
        this.gatherOutput();
        this.resultCodeCheck = new Predicate<Integer>(){

            public boolean apply(@Nullable Integer input) {
                if (input == 0) {
                    return true;
                }
                try {
                    String notes = "";
                    if (!WinRmExecuteHelper.this.getResultStderr().isEmpty()) {
                        notes = notes + "STDERR\n" + WinRmExecuteHelper.this.getResultStderr() + "\n";
                    }
                    if (!WinRmExecuteHelper.this.getResultStdout().isEmpty()) {
                        notes = notes + "\nSTDOUT\n" + WinRmExecuteHelper.this.getResultStdout() + "\n";
                    }
                    Tasks.setExtraStatusDetails((String)notes.trim());
                }
                catch (Exception e) {
                    LOG.warn("Unable to collect additional metadata on failure of " + WinRmExecuteHelper.this.summary + ": " + e);
                }
                return false;
            }
        };
        return this;
    }

    public WinRmExecuteHelper gatherOutput() {
        return this.gatherOutput(true);
    }

    public WinRmExecuteHelper gatherOutput(boolean gather) {
        this.gatherOutput = gather;
        return this;
    }

    protected RuntimeException logWithDetailsAndThrow(String message, Throwable optionalCause) {
        LOG.warn(message + " (throwing)");
        int maxLength = 1024;
        LOG.warn(message + " (throwing)");
        Streams.logStreamTail((Logger)LOG, (String)("STDERR of problem in " + Tasks.current()), (ByteArrayOutputStream)this.outStreams().stderrForReading, (int)maxLength);
        Streams.logStreamTail((Logger)LOG, (String)("STDOUT of problem in " + Tasks.current()), (ByteArrayOutputStream)this.outStreams().stdoutForReading, (int)maxLength);
        Streams.logStreamTail((Logger)LOG, (String)("STDIN of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)(this.command != null ? this.command : this.psCommand)), (int)4096);
        if (optionalCause != null) {
            throw new IllegalStateException(message, optionalCause);
        }
        throw new IllegalStateException(message);
    }

    public Map getFlags() {
        return this.flags;
    }

    public String getResultStdout() {
        if (this.outStreams().stdoutForReading == null) {
            throw new IllegalStateException("output not available on " + this + "; ensure gatherOutput(true) is set");
        }
        return this.outStreams().stdoutForReading.toString();
    }

    public String getResultStderr() {
        if (this.outStreams().stderrForReading == null) {
            throw new IllegalStateException("output not available on " + this + "; ensure gatherOutput(true) is set");
        }
        return this.outStreams().stderrForReading.toString();
    }
}

