/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.v1.kameletspec.DataTypes;
import org.apache.camel.v1.kameletspec.datatypes.Headers;
import org.apache.camel.v1.kameletspec.datatypes.Types;

public class DataTypesFluent<A extends DataTypesFluent<A>>
extends BaseFluent<A> {
    private Map<String, Headers> headers;
    private Map<String, Types> types;

    public DataTypesFluent() {
    }

    public DataTypesFluent(DataTypes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DataTypes instance) {
        DataTypes dataTypes = instance = instance != null ? instance : new DataTypes();
        if (instance != null) {
            this.withHeaders(instance.getHeaders());
            this.withTypes(instance.getTypes());
        }
    }

    public A addToHeaders(String key, Headers value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, Headers>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, Headers> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, Headers>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, Headers> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Headers> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, Headers> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, Headers>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public A addToTypes(String key, Types value) {
        if (this.types == null && key != null && value != null) {
            this.types = new LinkedHashMap<String, Types>();
        }
        if (key != null && value != null) {
            this.types.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTypes(Map<String, Types> map) {
        if (this.types == null && map != null) {
            this.types = new LinkedHashMap<String, Types>();
        }
        if (map != null) {
            this.types.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(String key) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        if (key != null && this.types != null) {
            this.types.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(Map<String, Types> map) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.types == null) continue;
                this.types.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Types> getTypes() {
        return this.types;
    }

    public <K, V> A withTypes(Map<String, Types> types) {
        this.types = types == null ? null : new LinkedHashMap<String, Types>(types);
        return (A)((Object)this);
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataTypesFluent that = (DataTypesFluent)((Object)o);
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        return Objects.equals(this.types, that.types);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.types, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.types != null && !this.types.isEmpty()) {
            sb.append("types:");
            sb.append(this.types);
        }
        sb.append("}");
        return sb.toString();
    }
}

