/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.awsddbexperimentalsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAwsddbexperimentalsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_CONF = "camel.kamelet.aws-ddb-experimental-sink.table";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_DOC = "The name of the DynamoDB table.";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_DEFAULT = null;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_CONF = "camel.kamelet.aws-ddb-experimental-sink.accessKey";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_DOC = "The access key obtained from AWS.";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_CONF = "camel.kamelet.aws-ddb-experimental-sink.secretKey";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_DOC = "The secret key obtained from AWS.";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_CONF = "camel.kamelet.aws-ddb-experimental-sink.region";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_DOC = "The AWS region to access.";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_DEFAULT = null;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_CONF = "camel.kamelet.aws-ddb-experimental-sink.operation";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_DOC = "The operation to perform. The options are PutItem, UpdateItem, or DeleteItem. Example: PutItem";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_DEFAULT = "PutItem";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_CONF = "camel.kamelet.aws-ddb-experimental-sink.writeCapacity";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_DOC = "The provisioned throughput to reserve for writing resources to your table.";
    public static final Integer CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_DEFAULT = 1;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF = "camel.kamelet.aws-ddb-experimental-sink.useDefaultCredentialsProvider";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC = "If true, the DynamoDB client loads credentials through a default credentials provider. If false, it uses the basic authentication method (access key and secret key).";
    public static final Boolean CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT = false;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_CONF = "camel.kamelet.aws-ddb-experimental-sink.uriEndpointOverride";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_DOC = "The overriding endpoint URI. To use this option, you must also select the `overrideEndpoint` option.";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT = null;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_CONF = "camel.kamelet.aws-ddb-experimental-sink.overrideEndpoint";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_DOC = "Select this option to override the endpoint URI. To use this option, you must also provide a URI for the `uriEndpointOverride` option.";
    public static final Boolean CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_CONF = "camel.kamelet.aws-ddb-experimental-sink.inputFormat";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_DOC = "Specify the input type for this Kamelet. The Kamelet will automatically apply conversion logic in order to transform message content to this data type. Example: json";
    public static final String CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_DEFAULT = "json";

    public CamelAwsddbexperimentalsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAwsddbexperimentalsinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_TABLE_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_SECRET_KEY_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_REGION_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OPERATION_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_CONF, ConfigDef.Type.INT, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_WRITE_CAPACITY_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_URI_ENDPOINT_OVERRIDE_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_OVERRIDE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWSDDBEXPERIMENTALSINK_KAMELET_INPUT_FORMAT_DOC);
        return conf;
    }
}