/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.splunkhecsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSplunkhecsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_CONF = "camel.kamelet.splunk-hec-sink.splunkUrl";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_DOC = "The URL of your Splunk server. No need to set the protocol prefix. Example: my_server.splunkcloud.com:8088";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_CONF = "camel.kamelet.splunk-hec-sink.token";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_DOC = "The Token of the HEC. Note it is not the user's authentication token.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_CONF = "camel.kamelet.splunk-hec-sink.hostPayload";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_DOC = "The host field set in the data sent to Splunk, it is not related to the Splunk URL or the connection to Splunk server.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_CONF = "camel.kamelet.splunk-hec-sink.bodyOnly";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_DOC = "Send to Splunk only data contained in the body.";
    public static final Boolean CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_DEFAULT = false;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_CONF = "camel.kamelet.splunk-hec-sink.headersOnly";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_DOC = "Send to Splunk only data contained in the headers.";
    public static final Boolean CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_DEFAULT = false;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_CONF = "camel.kamelet.splunk-hec-sink.index";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_DOC = "Splunk index to write to.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_CONF = "camel.kamelet.splunk-hec-sink.source";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_DOC = "The source named field of the data.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_CONF = "camel.kamelet.splunk-hec-sink.sourceType";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_DOC = "The source named field of the data.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_CONF = "camel.kamelet.splunk-hec-sink.skipTlsVerify";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_DOC = "Skip TLS verification.";
    public static final Boolean CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_DEFAULT = false;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_CONF = "camel.kamelet.splunk-hec-sink.https";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_DOC = "Use a secure HTTPS connection.";
    public static final Boolean CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_DEFAULT = true;
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_CONF = "camel.kamelet.splunk-hec-sink.time";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_DOC = "Time this even occurred. By default, the time will be when this event hits the splunk server.";
    public static final String CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_DEFAULT = null;

    public CamelSplunkhecsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSplunkhecsinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SPLUNK_URL_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SPLUNKHECSINK_KAMELET_TOKEN_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HOST_PAYLOAD_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_BODY_ONLY_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HEADERS_ONLY_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_INDEX_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SOURCE_TYPE_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_SKIP_TLS_VERIFY_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_HTTPS_DOC);
        conf.define(CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SPLUNKHECSINK_KAMELET_TIME_DOC);
        return conf;
    }
}