/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.merge.MergerDictionary;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;

public class ProcedureDictionary
extends MergerDictionary<Procedure> {
    private final DataMap container;
    private final FiltersConfig filtersConfig;

    ProcedureDictionary(DataMap container, FiltersConfig filtersConfig) {
        this.container = container;
        this.filtersConfig = filtersConfig;
    }

    @Override
    String getName(Procedure entity) {
        return entity.getName();
    }

    @Override
    Collection<Procedure> getAll() {
        return this.filter();
    }

    private Collection<Procedure> filter() {
        if (this.filtersConfig == null) {
            return this.container.getProcedures();
        }
        LinkedList<Procedure> existingFiltered = new LinkedList<Procedure>();
        for (Procedure procedure : this.container.getProcedures()) {
            PatternFilter patternFilter = this.filtersConfig.proceduresFilter(procedure.getCatalog(), procedure.getSchema());
            if (patternFilter == null || !patternFilter.isIncluded(procedure.getName())) continue;
            existingFiltered.add(procedure);
        }
        return existingFiltered;
    }
}

