/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.validation.SimpleValidationFailure;

public class CreateTableToDb
extends AbstractToDbToken.Entity {
    public CreateTableToDb(DbEntity entity) {
        super("Create Table", 40, entity);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        ArrayList<String> sqls = new ArrayList<String>();
        if (this.needAutoPkSupport()) {
            sqls.addAll(adapter.getPkGenerator().createAutoPkStatements(Collections.singletonList(this.getEntity())));
        }
        sqls.add(adapter.createTable(this.getEntity()));
        return sqls;
    }

    @Override
    public void execute(MergerContext mergerContext) {
        try {
            DataNode node = mergerContext.getDataNode();
            DbAdapter adapter = node.getAdapter();
            if (this.needAutoPkSupport()) {
                adapter.getPkGenerator().createAutoPk(node, Collections.singletonList(this.getEntity()));
            }
            this.executeSql(mergerContext, adapter.createTable(this.getEntity()));
        }
        catch (Exception e) {
            mergerContext.getValidationResult().addFailure(new SimpleValidationFailure(this, e.getMessage()));
        }
    }

    private boolean needAutoPkSupport() {
        DbEntity entity = this.getEntity();
        if (entity.getPrimaryKeyGenerator() != null) {
            return false;
        }
        for (DbAttribute attribute : entity.getPrimaryKeys()) {
            if (!attribute.isGenerated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropTableToModel(this.getEntity());
    }
}

