/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.configuration;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DataSourceDescriptor;
import org.apache.cayenne.configuration.runtime.DataSourceFactory;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class DriverDataSourceFactory
implements DataSourceFactory {
    private AdhocObjectFactory objectFactory;

    public DriverDataSourceFactory(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSourceDescriptor dataSourceDescriptor = nodeDescriptor.getDataSourceDescriptor();
        if (dataSourceDescriptor == null) {
            throw new IllegalArgumentException("'nodeDescriptor' contains no datasource descriptor");
        }
        Driver driver = (Driver)this.objectFactory.getJavaClass(dataSourceDescriptor.getJdbcDriver()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return new DriverDataSource(driver, dataSourceDescriptor.getDataSourceUrl(), dataSourceDescriptor.getUserName(), dataSourceDescriptor.getPassword());
    }
}

