/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.AbstractLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;

public abstract class PerCatalogAndSchemaLoader
extends AbstractLoader {
    PerCatalogAndSchemaLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    public void load(DatabaseMetaData metaData, DbLoadDataStore map) throws SQLException {
        for (CatalogFilter catalog : this.config.getFiltersConfig().getCatalogs()) {
            for (SchemaFilter schema : catalog.schemas) {
                if (!this.shouldLoad(catalog, schema)) continue;
                try (ResultSet rs = this.getResultSet(catalog.name, schema.name, metaData);){
                    while (rs.next()) {
                        this.processResultSetRow(catalog, schema, map, rs);
                    }
                }
                catch (SQLException ex) {
                    if (this.catchException(catalog.name, schema.name, ex)) continue;
                    throw ex;
                }
            }
        }
    }

    boolean catchException(String catalogName, String schemaName, SQLException ex) {
        return false;
    }

    boolean shouldLoad(CatalogFilter catalog, SchemaFilter schema) {
        return true;
    }

    abstract ResultSet getResultSet(String var1, String var2, DatabaseMetaData var3) throws SQLException;

    abstract void processResultSetRow(CatalogFilter var1, SchemaFilter var2, DbLoadDataStore var3, ResultSet var4) throws SQLException;
}

