/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.GenericPersistentObject;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.PathComponentIterator;
import org.apache.cayenne.map.SyntheticPKObjAttribute;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjEntity
extends Entity<ObjEntity, ObjAttribute, ObjRelationship>
implements ObjEntityListener,
ConfigurationNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjEntity.class);
    public static final int LOCK_TYPE_NONE = 0;
    public static final int LOCK_TYPE_OPTIMISTIC = 1;
    private static final String CAYENNE_GENERIC_PERSISTENT_OBJECT_CLASS = GenericPersistentObject.class.getName();
    protected static final Collection<String> DEFAULT_GENERIC_CLASSES = Collections.singleton(CAYENNE_GENERIC_PERSISTENT_OBJECT_CLASS);
    protected String superClassName;
    protected String className;
    protected String dbEntityName;
    protected String superEntityName;
    protected Expression qualifier;
    protected boolean readOnly;
    protected int lockType;
    protected boolean _abstract;
    protected CallbackMap callbacks;
    protected Map<String, CayennePath> attributeOverrides;

    public ObjEntity() {
        this(null);
    }

    public ObjEntity(String name) {
        this.setName(name);
        this.lockType = 0;
        this.callbacks = new CallbackMap();
        this.attributeOverrides = new TreeMap<String, CayennePath>();
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitObjEntity(this);
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("obj-entity").attribute("name", this.getName());
        if (this.getSuperEntityName() != null && this.getSuperEntity() != null) {
            encoder.attribute("superEntityName", this.getSuperEntityName());
        }
        encoder.attribute("abstract", this.isAbstract()).attribute("className", this.getClassName()).attribute("readOnly", this.isReadOnly());
        if (this.getDeclaredLockType() == 1) {
            encoder.attribute("lock-type", "optimistic");
        }
        if (this.getDbEntityName() != null && this.getDbEntity() != null && (this.getSuperEntity() == null || this.getSuperEntity().getDbEntity() != this.getDbEntity())) {
            encoder.attribute("dbEntityName", this.getDbEntityName());
        }
        if (this.getSuperEntityName() == null && this.getSuperClassName() != null) {
            encoder.attribute("superClassName", this.getSuperClassName());
        }
        if (this.qualifier != null) {
            encoder.start("qualifier").nested(this.qualifier, delegate).end();
        }
        TreeMap embAttributes = new TreeMap();
        TreeMap objAttributes = new TreeMap();
        this.attributes.forEach((key, value) -> {
            if (value instanceof EmbeddedAttribute) {
                embAttributes.put(key, value);
            } else {
                objAttributes.put(key, value);
            }
        });
        encoder.nested(embAttributes, delegate);
        encoder.nested(objAttributes, delegate);
        for (Map.Entry<String, CayennePath> override : this.attributeOverrides.entrySet()) {
            encoder.start("attribute-override").attribute("name", override.getKey()).attribute("db-attribute-path", override.getValue().value()).end();
        }
        this.getCallbackMap().encodeCallbacksAsXML(encoder);
        delegate.visitObjEntity(this);
        encoder.end();
    }

    public String getJavaClassName() {
        String name = this.getClassName();
        if (name == null && this.getDataMap() != null) {
            name = this.getDataMap().getDefaultSuperclass();
        }
        if (name == null) {
            name = CAYENNE_GENERIC_PERSISTENT_OBJECT_CLASS;
        }
        return name;
    }

    public CallbackMap getCallbackMap() {
        return this.callbacks;
    }

    public int getLockType() {
        if (this.lockType != 0) {
            return this.lockType;
        }
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getLockType() : this.lockType;
    }

    public int getDeclaredLockType() {
        return this.lockType;
    }

    public void setDeclaredLockType(int i) {
        this.lockType = i;
    }

    public boolean isGeneric() {
        String className = this.getClassName();
        return className == null || DEFAULT_GENERIC_CLASSES.contains(className) || this.getDataMap() != null && className.equals(this.getDataMap().getDefaultSuperclass());
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean isAbstract) {
        this._abstract = isAbstract;
    }

    public Expression getDeclaredQualifier() {
        return this.qualifier;
    }

    public String getSuperEntityName() {
        return this.superEntityName;
    }

    public void setDeclaredQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public void setSuperEntityName(String superEntityName) {
        this.superEntityName = superEntityName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getClassName() : this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public ObjEntity getSuperEntity() {
        return this.superEntityName != null ? this.getNonNullNamespace().getObjEntity(this.superEntityName) : null;
    }

    public DbEntity getDbEntity() {
        if (this.dbEntityName != null) {
            return this.getNonNullNamespace().getDbEntity(this.dbEntityName);
        }
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            return superEntity.getDbEntity();
        }
        return null;
    }

    public void setDbEntity(DbEntity dbEntity) {
        this.dbEntityName = dbEntity != null ? dbEntity.getName() : null;
    }

    public Collection<ObjAttribute> getPrimaryKeys() {
        return Collections.unmodifiableCollection(this.getMutablePrimaryKeys());
    }

    private Collection<ObjAttribute> getMutablePrimaryKeys() {
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("No DbEntity for ObjEntity: %s", this.getName());
        }
        List<DbAttribute> pkAttributes = this.getDbEntity().getPrimaryKeys();
        ArrayList<ObjAttribute> attributes = new ArrayList<ObjAttribute>(pkAttributes.size());
        for (DbAttribute pk : pkAttributes) {
            ObjAttribute attribute = this.getAttributeForDbAttribute(pk);
            if (attribute == null) {
                attribute = new SyntheticPKObjAttribute(Util.underscoredToJava(pk.getName(), false));
                attribute.setDbAttributePath(pk.getName());
                attribute.setType(TypesMapping.getJavaBySqlType(pk));
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public ObjAttribute getAttribute(String name) {
        ObjAttribute embedded;
        ObjAttribute attribute = (ObjAttribute)super.getAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        int dot = name.indexOf(46);
        if (dot > 0 && dot < name.length() - 1 && (embedded = this.getAttribute(name.substring(0, dot))) instanceof EmbeddedAttribute) {
            return ((EmbeddedAttribute)embedded).getAttribute(name.substring(dot + 1));
        }
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            ObjAttribute superAttribute = superEntity.getAttribute(name);
            if (superAttribute == null) {
                return null;
            }
            ObjAttribute decoratedAttribute = new ObjAttribute(superAttribute);
            decoratedAttribute.setEntity(this);
            CayennePath pathOverride = this.attributeOverrides.get(name);
            if (pathOverride != null) {
                decoratedAttribute.setDbAttributePath(pathOverride);
            }
            return decoratedAttribute;
        }
        return null;
    }

    @Override
    public Map<String, ObjAttribute> getAttributeMap() {
        if (this.superEntityName == null) {
            return this.getAttributeMapInternal();
        }
        HashMap<String, ObjAttribute> attributeMap = new HashMap<String, ObjAttribute>();
        this.appendAttributes(attributeMap);
        return attributeMap;
    }

    final void appendAttributes(Map<String, ObjAttribute> map) {
        map.putAll(this.getAttributeMapInternal());
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            HashMap<String, ObjAttribute> attributeMap = new HashMap<String, ObjAttribute>();
            superEntity.appendAttributes(attributeMap);
            for (String attributeName : attributeMap.keySet()) {
                ObjAttribute attribute;
                CayennePath overridedDbPath = this.attributeOverrides.get(attributeName);
                ObjAttribute superAttribute = (ObjAttribute)attributeMap.get(attributeName);
                if (superAttribute instanceof EmbeddedAttribute) {
                    EmbeddedAttribute embeddedAttribute = new EmbeddedAttribute((EmbeddedAttribute)superAttribute);
                    if (overridedDbPath != null) {
                        LOGGER.warn("'{}.{}': DB path override for an embedded attribute is not supported.", (Object)this.getName(), (Object)attributeName);
                    }
                    attribute = embeddedAttribute;
                } else {
                    attribute = new ObjAttribute(superAttribute);
                    if (overridedDbPath != null) {
                        attribute.setDbAttributePath(overridedDbPath);
                    }
                }
                attribute.setEntity(this);
                map.put(attributeName, attribute);
            }
        }
    }

    final Map<String, ObjAttribute> getAttributeMapInternal() {
        return super.getAttributeMap();
    }

    public void addAttributeOverride(String attributeName, String dbPath) {
        this.addAttributeOverride(attributeName, CayennePath.of(dbPath));
    }

    public void addAttributeOverride(String attributeName, CayennePath dbPath) {
        this.attributeOverrides.put(attributeName, dbPath);
    }

    public void removeAttributeOverride(String attributeName) {
        this.attributeOverrides.remove(attributeName);
    }

    public Map<String, CayennePath> getDeclaredAttributeOverrides() {
        return Collections.unmodifiableMap(this.attributeOverrides);
    }

    @Override
    public Collection<ObjAttribute> getAttributes() {
        return this.getAttributeMap().values();
    }

    public Collection<ObjAttribute> getDeclaredAttributes() {
        return super.getAttributes();
    }

    public ObjAttribute getDeclaredAttribute(String name) {
        return (ObjAttribute)super.getAttribute(name);
    }

    @Override
    public ObjRelationship getRelationship(String name) {
        ObjRelationship relationship = (ObjRelationship)super.getRelationship(name);
        if (relationship != null) {
            return relationship;
        }
        if (this.superEntityName == null) {
            return null;
        }
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getRelationship(name) : null;
    }

    @Override
    public Map<String, ObjRelationship> getRelationshipMap() {
        if (this.superEntityName == null) {
            return super.getRelationshipMap();
        }
        HashMap<String, ObjRelationship> relationshipMap = new HashMap<String, ObjRelationship>();
        this.appendRelationships(relationshipMap);
        return relationshipMap;
    }

    final void appendRelationships(Map<String, ObjRelationship> map) {
        map.putAll(super.getRelationshipMap());
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            superEntity.appendRelationships(map);
        }
    }

    @Override
    public Collection<ObjRelationship> getRelationships() {
        return this.getRelationshipMap().values();
    }

    public Collection<ObjRelationship> getDeclaredRelationships() {
        return super.getRelationships();
    }

    public ObjAttribute getAttributeForDbAttribute(DbAttribute dbAttribute) {
        for (ObjAttribute next : this.getAttributeMap().values()) {
            if (next instanceof EmbeddedAttribute) {
                ObjAttribute embeddedAttribute = ((EmbeddedAttribute)next).getAttributeForDbPath(dbAttribute.getName());
                if (embeddedAttribute == null) continue;
                return embeddedAttribute;
            }
            if (next.getDbAttribute() != dbAttribute) continue;
            return next;
        }
        return null;
    }

    public Collection<String> getPrimaryKeyNames() {
        DbEntity dbEntity = this.getDbEntity();
        if (dbEntity == null) {
            return Collections.emptyList();
        }
        List<DbAttribute> pkAttributes = dbEntity.getPrimaryKeys();
        ArrayList<String> names = new ArrayList<String>(pkAttributes.size());
        for (DbAttribute pk : pkAttributes) {
            names.add(pk.getName());
        }
        return Collections.unmodifiableCollection(names);
    }

    public ObjRelationship getRelationshipForDbRelationship(DbRelationship dbRelationship) {
        for (ObjRelationship objRel : this.getRelationshipMap().values()) {
            List<DbRelationship> relList = objRel.getDbRelationships();
            if (relList.size() != 1 || relList.get(0) != dbRelationship) continue;
            return objRel;
        }
        return null;
    }

    public void clearDbMapping() {
        if (this.dbEntityName == null) {
            return;
        }
        for (ObjAttribute attribute : this.getAttributeMap().values()) {
            DbAttribute dbAttr = attribute.getDbAttribute();
            if (dbAttr == null) continue;
            attribute.setDbAttributePath((String)null);
        }
        for (ObjRelationship relationship : this.getRelationships()) {
            relationship.clearDbRelationships();
        }
        this.dbEntityName = null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSubentityOf(ObjEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return false;
        }
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity == entity) {
            return true;
        }
        return superEntity != null && superEntity.isSubentityOf(entity);
    }

    @Override
    public Iterable<PathComponent<ObjAttribute, ObjRelationship>> resolvePath(Expression pathExp, Map<String, String> aliasMap) {
        if (pathExp.getType() == 26) {
            return () -> new PathComponentIterator<ObjEntity, ObjAttribute, ObjRelationship>(this, (CayennePath)pathExp.getOperand(0), aliasMap);
        }
        throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  OBJ_PATH is expected.", new Object[0]);
    }

    @Override
    public Iterator<CayenneMapEntry> resolvePathComponents(Expression pathExp) throws ExpressionException {
        if (pathExp.getType() == 27) {
            if (this.getDbEntity() == null) {
                throw new ExpressionException("Can't resolve DB_PATH '" + pathExp + "', DbEntity is not set.", new Object[0]);
            }
            return this.getDbEntity().resolvePathComponents(pathExp);
        }
        if (pathExp.getType() == 26) {
            return new Entity.PathIterator((CayennePath)pathExp.getOperand(0));
        }
        throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  OBJ_PATH is expected.", new Object[0]);
    }

    public Expression translateToDbPath(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("Can't translate expression to DB_PATH, no DbEntity for '%s'.", this.getName());
        }
        return expression.transform(new DBPathConverter());
    }

    @Override
    public Expression translateToRelatedEntity(Expression expression, String relationshipPath) {
        return this.translateToRelatedEntity(expression, CayennePath.of(relationshipPath));
    }

    @Override
    public Expression translateToRelatedEntity(Expression expression, CayennePath relationshipPath) {
        if (expression == null) {
            return null;
        }
        if (relationshipPath == null || relationshipPath.isEmpty()) {
            return expression;
        }
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("Can't transform expression, no DbEntity for '%s'.", this.getName());
        }
        DBPathConverter transformer = new DBPathConverter();
        CayennePath dbPath = transformer.toDbPath(this.createPathIterator(relationshipPath, expression.getPathAliases()));
        Expression dbClone = expression.transform(transformer);
        return this.getDbEntity().translateToRelatedEntity(dbClone, dbPath);
    }

    private PathComponentIterator<ObjEntity, ObjAttribute, ObjRelationship> createPathIterator(CayennePath path, Map<String, String> aliasMap) {
        return new PathComponentIterator<ObjEntity, ObjAttribute, ObjRelationship>(this, path, aliasMap);
    }

    public Set<String> getCallbackMethods() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (CallbackDescriptor descriptor : this.getCallbackMap().getCallbacks()) {
            res.addAll(descriptor.getCallbackMethods());
        }
        return res;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public void setDbEntityName(String string) {
        this.dbEntityName = string;
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                ObjEntity oe = (ObjEntity)e.getEntity();
                for (ObjRelationship relationship : oe.getRelationships()) {
                    if (null == (relationship = relationship.getReverseRelationship()) || !relationship.targetEntityName.equals(oldName)) continue;
                    relationship.targetEntityName = newName;
                }
            }
        }
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
    }

    final class DBPathConverter
    implements Function<Object, Object> {
        DBPathConverter() {
        }

        CayennePath toDbPath(PathComponentIterator<ObjEntity, ObjAttribute, ObjRelationship> objectPathComponents) {
            CayennePath path = CayennePath.EMPTY_PATH;
            while (objectPathComponents.hasNext()) {
                Iterator<CayenneMapEntry> dbSubpath;
                Object component = objectPathComponents.next();
                if (component.getAttribute() != null) {
                    dbSubpath = ((ObjAttribute)component.getAttribute()).getDbPathIterator();
                    path = this.buildPath(dbSubpath, (PathComponent<ObjAttribute, ObjRelationship>)component, path);
                    continue;
                }
                if (component.getRelationship() != null) {
                    dbSubpath = ((ObjRelationship)component.getRelationship()).getDbRelationships().iterator();
                    path = this.buildPath(dbSubpath, (PathComponent<ObjAttribute, ObjRelationship>)component, path);
                    continue;
                }
                if (component.getAliasedPath() != null) {
                    for (PathComponent<ObjAttribute, ObjRelationship> pathComponent : component.getAliasedPath()) {
                        if (pathComponent.getRelationship() == null) continue;
                        dbSubpath = ((ObjRelationship)pathComponent.getRelationship()).getDbRelationships().iterator();
                        path = this.buildPath(dbSubpath, pathComponent, path);
                    }
                    continue;
                }
                throw new CayenneRuntimeException("Unknown path component: %s", component);
            }
            return path;
        }

        private CayennePath buildPath(Iterator<? extends CayenneMapEntry> dbSubpath, PathComponent<ObjAttribute, ObjRelationship> component, CayennePath path) {
            while (dbSubpath.hasNext()) {
                String subComponent = dbSubpath.next().getName();
                boolean outer = component.getJoinType() == JoinType.LEFT_OUTER;
                path = path.dot(CayennePath.segmentOf(subComponent, outer));
            }
            return path;
        }

        @Override
        public Object apply(Object input) {
            if (!(input instanceof Expression)) {
                return input;
            }
            Expression expression = (Expression)input;
            if (expression.getType() != 26) {
                return input;
            }
            CayennePath converted = this.toDbPath(ObjEntity.this.createPathIterator((CayennePath)expression.getOperand(0), expression.getPathAliases()));
            return ExpressionFactory.dbPathExp(converted);
        }
    }
}

