/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CreateDataMapUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateDataMapAction
extends CayenneAction {
    public static String getActionName() {
        return "Create DataMap";
    }

    public CreateDataMapAction(Application application) {
        super(CreateDataMapAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-datamap.png";
    }

    public void createDataMap(DataMap map) {
        ProjectController mediator = this.getProjectController();
        mediator.addDataMap(this, map);
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataMap map = new DataMap();
        map.setName(NameBuilder.builder(map, dataChannelDescriptor).name());
        this.createDataMap(map);
        this.application.getUndoManager().addEdit(new CreateDataMapUndoableEdit(dataChannelDescriptor, map));
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((DataNodeDescriptor)object).getDataChannelDescriptor() != null;
    }
}

