/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.modeler.editor.cgen.CgenController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.validation.ValidationException;

public class CgenConfigPanel
extends JPanel {
    protected TextAdapter outputFolder;
    protected JButton selectOutputFolder;
    protected CgenController cgenController;
    private boolean isDataValid;
    private final String INVALID_PATH_MSG = "An invalid path has been detected. It cannot be saved or used until it is corrected.";
    private final String NEED_TO_SAVE_PROJECT_MSG = "You should save project to use relative path as an output directory.";
    private final JCheckBox pairs;
    private final JCheckBox overwrite;
    private final JCheckBox usePackagePath;
    private final JCheckBox createPropertyNames;
    private final JCheckBox pkProperties;
    private TextAdapter superPkg;
    protected TextAdapter outputPattern;
    private JButton editSuperclassTemplateBtn;
    private JButton editSubclassTemplateBtn;
    private JButton editEmbeddableTemplateBtn;
    private JButton editEmbeddableSuperTemplateBtn;
    private JButton editDataMapTemplateBtn;
    private JButton editDataMapSuperTemplateBtn;
    private JLabel entityTemplateLbl;
    private JLabel entitySuperTemplateLbl;
    private JLabel embeddableTemplateLbl;
    private JLabel embeddableSuperTemplateLbl;
    private JLabel datamapTemplateLbl;
    private JLabel datamapSuperTemplateLbl;
    static final Border CGEN_PANEL_BORDER = BorderFactory.createEmptyBorder(5, 13, 5, 13);

    public CgenConfigPanel(CgenController cgenController) {
        this.cgenController = cgenController;
        this.selectOutputFolder = new JButton("..");
        this.pairs = new JCayenneCheckBox();
        this.overwrite = new JCayenneCheckBox();
        this.usePackagePath = new JCayenneCheckBox();
        this.createPropertyNames = new JCayenneCheckBox();
        this.pkProperties = new JCayenneCheckBox();
        this.initTextFields();
        this.initEditTemplateLabels();
        this.initEditTemplateButtons();
        this.buildView();
    }

    private void initEditTemplateLabels() {
        this.entityTemplateLbl = new JLabel(TemplateType.ENTITY_SUBCLASS.readableName());
        this.entitySuperTemplateLbl = new JLabel(TemplateType.ENTITY_SUPERCLASS.readableName());
        this.embeddableTemplateLbl = new JLabel(TemplateType.EMBEDDABLE_SUBCLASS.readableName());
        this.embeddableSuperTemplateLbl = new JLabel(TemplateType.EMBEDDABLE_SUPERCLASS.readableName());
        this.datamapTemplateLbl = new JLabel(TemplateType.DATAMAP_SUBCLASS.readableName());
        this.datamapSuperTemplateLbl = new JLabel(TemplateType.DATAMAP_SUPERCLASS.readableName());
    }

    private void initEditTemplateButtons() {
        this.editSubclassTemplateBtn = new JButton("Edit");
        this.editSuperclassTemplateBtn = new JButton("Edit");
        this.editEmbeddableTemplateBtn = new JButton("Edit");
        this.editEmbeddableSuperTemplateBtn = new JButton("Edit");
        this.editDataMapTemplateBtn = new JButton("Edit");
        this.editDataMapSuperTemplateBtn = new JButton("Edit");
    }

    protected void buildView() {
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("left:10dlu, 3dlu, 97dlu, 3dlu, 40dlu, 3dlu, 50dlu, 3dlu, 20dlu", "p, 3dlu, p, 10dlu, 11*(p, 3dlu),10dlu,9*(p, 3dlu)");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addLabel("Output Directory", cc.xyw(1, 1, 3));
        builder.add((Component)this.outputFolder.getComponent(), cc.xyw(1, 3, 7));
        builder.add((Component)this.selectOutputFolder, cc.xy(9, 3));
        builder.addSeparator("Advanced options", cc.xyw(1, 7, 9));
        builder.add((Component)this.pairs, cc.xy(1, 9));
        builder.addLabel("Make Pairs", cc.xyw(3, 9, 3));
        builder.add((Component)this.usePackagePath, cc.xy(1, 11));
        builder.addLabel("Use Package Path", cc.xyw(3, 11, 3));
        builder.add((Component)this.overwrite, cc.xy(1, 13));
        builder.addLabel("Overwrite Subclasses", cc.xyw(3, 13, 3));
        builder.add((Component)this.createPropertyNames, cc.xy(1, 15));
        builder.addLabel("Create Property Names", cc.xyw(3, 15, 3));
        builder.add((Component)this.pkProperties, cc.xy(1, 17));
        builder.addLabel("Create PK properties", cc.xyw(3, 17, 3));
        builder.addLabel("Output Pattern", cc.xyw(1, 19, 5));
        builder.add((Component)this.outputPattern.getComponent(), cc.xyw(1, 21, 5));
        builder.addLabel("Superclass package", cc.xyw(1, 23, 5));
        builder.add((Component)this.superPkg.getComponent(), cc.xyw(1, 25, 5));
        builder.addSeparator("Templates options", cc.xyw(1, 28, 9));
        builder.add((Component)this.entityTemplateLbl, cc.xyw(1, 30, 3));
        builder.add((Component)this.editSubclassTemplateBtn, cc.xy(5, 30));
        builder.add((Component)this.entitySuperTemplateLbl, cc.xyw(1, 32, 3));
        builder.add((Component)this.editSuperclassTemplateBtn, cc.xy(5, 32));
        builder.add((Component)this.embeddableTemplateLbl, cc.xyw(1, 34, 3));
        builder.add((Component)this.editEmbeddableTemplateBtn, cc.xy(5, 34));
        builder.add((Component)this.embeddableSuperTemplateLbl, cc.xyw(1, 36, 3));
        builder.add((Component)this.editEmbeddableSuperTemplateBtn, cc.xy(5, 36));
        builder.add((Component)this.datamapTemplateLbl, cc.xyw(1, 38, 3));
        builder.add((Component)this.editDataMapTemplateBtn, cc.xy(5, 38));
        builder.add((Component)this.datamapSuperTemplateLbl, cc.xyw(1, 40, 3));
        builder.add((Component)this.editDataMapSuperTemplateBtn, cc.xy(5, 40));
        builder.getPanel().setBorder(CGEN_PANEL_BORDER);
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initTextFields() {
        JTextField superPkgField = new JTextField();
        this.superPkg = new TextAdapter(superPkgField){

            @Override
            protected void updateModel(String text) throws ValidationException {
                CgenConfigPanel.this.getCgenConfig().setSuperPkg(text);
                CgenConfigPanel.this.checkConfigDirty();
            }
        };
        JTextField outputPatternField = new JTextField();
        this.outputPattern = new TextAdapter(outputPatternField){

            @Override
            protected void updateModel(String text) {
                CgenConfigPanel.this.getCgenConfig().setOutputPattern(text);
                CgenConfigPanel.this.checkConfigDirty();
            }
        };
        this.outputFolder = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                CgenConfiguration cgenByDataMap = CgenConfigPanel.this.getCgenConfig();
                if (cgenByDataMap != null) {
                    Path path;
                    try {
                        path = Paths.get(text, new String[0]);
                    }
                    catch (InvalidPathException e) {
                        CgenConfigPanel.this.updateGenerateButton(false);
                        throw new ValidationException("An invalid path has been detected. It cannot be saved or used until it is corrected.", new Object[0]);
                    }
                    if (cgenByDataMap.getRootPath() == null && !path.isAbsolute()) {
                        CgenConfigPanel.this.updateGenerateButton(false);
                        throw new ValidationException("You should save project to use relative path as an output directory.", new Object[0]);
                    }
                    cgenByDataMap.updateOutputPath(path);
                    CgenConfigPanel.this.updateGenerateButton(true);
                    CgenConfigPanel.this.checkConfigDirty();
                }
            }

            @Override
            public void setText(String text) {
                super.setText(text);
                try {
                    Paths.get(text, new String[0]);
                }
                catch (InvalidPathException e) {
                    CgenConfigPanel.this.updateGenerateButton(false);
                    throw new ValidationException("An invalid path has been detected. It cannot be saved or used until it is corrected.", new Object[0]);
                }
                CgenConfigPanel.this.updateGenerateButton(true);
            }
        };
    }

    private void updateGenerateButton(boolean isDataValid) {
        this.isDataValid = isDataValid;
        this.cgenController.updateGenerateButton();
    }

    public JCheckBox getPairs() {
        return this.pairs;
    }

    public JCheckBox getOverwrite() {
        return this.overwrite;
    }

    public JCheckBox getUsePackagePath() {
        return this.usePackagePath;
    }

    public JCheckBox getCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public JCheckBox getPkProperties() {
        return this.pkProperties;
    }

    public TextAdapter getOutputPattern() {
        return this.outputPattern;
    }

    public TextAdapter getSuperPkg() {
        return this.superPkg;
    }

    public JButton getEditSuperclassTemplateBtn() {
        return this.editSuperclassTemplateBtn;
    }

    public JButton getEditSubclassTemplateBtn() {
        return this.editSubclassTemplateBtn;
    }

    public JButton getEditEmbeddableTemplateBtn() {
        return this.editEmbeddableTemplateBtn;
    }

    public JButton getEditEmbeddableSuperTemplateBtn() {
        return this.editEmbeddableSuperTemplateBtn;
    }

    public JButton getEditDataMapTemplateBtn() {
        return this.editDataMapTemplateBtn;
    }

    public JButton getEditDataMapSuperTemplateBtn() {
        return this.editDataMapSuperTemplateBtn;
    }

    public JLabel getEntityTemplateLbl() {
        return this.entityTemplateLbl;
    }

    public JLabel getEntitySuperTemplateLbl() {
        return this.entitySuperTemplateLbl;
    }

    public JLabel getEmbeddableTemplateLbl() {
        return this.embeddableTemplateLbl;
    }

    public JLabel getEmbeddableSuperTemplateLbl() {
        return this.embeddableSuperTemplateLbl;
    }

    public JLabel getDatamapTemplateLbl() {
        return this.datamapTemplateLbl;
    }

    public JLabel getDatamapSuperTemplateLbl() {
        return this.datamapSuperTemplateLbl;
    }

    public TextAdapter getOutputFolder() {
        return this.outputFolder;
    }

    public JButton getSelectOutputFolder() {
        return this.selectOutputFolder;
    }

    protected void checkConfigDirty() {
        this.cgenController.checkCgenConfigDirty();
    }

    protected CgenConfiguration getCgenConfig() {
        return this.cgenController.getCgenConfiguration();
    }

    public boolean isDataValid() {
        return this.isDataValid;
    }
}

