/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.GetDbConnectionAction;
import org.apache.cayenne.modeler.action.SortNodesAction;
import org.apache.cayenne.modeler.action.dbimport.AddCatalogAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeColumnAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeProcedureAction;
import org.apache.cayenne.modeler.action.dbimport.AddExcludeTableAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeColumnAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeProcedureAction;
import org.apache.cayenne.modeler.action.dbimport.AddIncludeTableAction;
import org.apache.cayenne.modeler.action.dbimport.AddPatternParamAction;
import org.apache.cayenne.modeler.action.dbimport.AddSchemaAction;
import org.apache.cayenne.modeler.action.dbimport.DeleteNodeAction;
import org.apache.cayenne.modeler.action.dbimport.EditNodeAction;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;

class TreeToolbarPanel
extends JToolBar {
    private JButton schemaButton;
    private JButton catalogButton;
    private JButton includeTableButton;
    private JButton excludeTableButton;
    private JButton includeColumnButton;
    private JButton excludeColumnButton;
    private JButton includeProcedureButton;
    private JButton excludeProcedureButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton configureButton;
    private JButton sortButton;
    private DbImportTree reverseEngineeringTree;
    private Map<Class, List<JButton>> levels;
    private ProjectController projectController;

    TreeToolbarPanel(ProjectController projectController, DbImportTree reverseEngineeringTree, DraggableTreePanel treePanel) {
        this.projectController = projectController;
        this.reverseEngineeringTree = reverseEngineeringTree;
        this.createButtons(treePanel);
        this.initLevels();
        this.addButtons();
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    void unlockButtons() {
        this.changeToolbarButtonsState(true);
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    private boolean isLabelSelected() {
        DbImportTreeNode selectedNode = this.reverseEngineeringTree.getSelectedNode();
        return selectedNode.getUserObject().getClass() == String.class;
    }

    void lockButtons() {
        if (this.reverseEngineeringTree.getLastSelectedPathComponent() != null && !this.isLabelSelected()) {
            DbImportTreeNode selectedNode = (DbImportTreeNode)this.reverseEngineeringTree.getLastSelectedPathComponent();
            DbImportTreeNode parentNode = selectedNode.getParent();
            if (parentNode != null) {
                this.lockButtons(parentNode.getUserObject());
            } else {
                this.unlockButtons();
            }
        } else {
            this.changeToolbarButtonsState(true);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        if (this.reverseEngineeringTree.getSelectionPaths() != null && this.reverseEngineeringTree.getSelectionPaths().length > 1) {
            this.changeToolbarButtonsState(false);
            this.deleteButton.setEnabled(true);
        }
    }

    private void initLevels() {
        this.levels = new HashMap<Class, List<JButton>>();
        ArrayList<JButton> rootLevelButtons = new ArrayList<JButton>();
        rootLevelButtons.add(this.catalogButton);
        rootLevelButtons.add(this.schemaButton);
        rootLevelButtons.add(this.includeTableButton);
        rootLevelButtons.add(this.excludeTableButton);
        rootLevelButtons.add(this.includeColumnButton);
        rootLevelButtons.add(this.excludeColumnButton);
        rootLevelButtons.add(this.includeProcedureButton);
        rootLevelButtons.add(this.excludeProcedureButton);
        ArrayList<JButton> catalogLevelButtons = new ArrayList<JButton>();
        catalogLevelButtons.add(this.schemaButton);
        catalogLevelButtons.add(this.includeTableButton);
        catalogLevelButtons.add(this.excludeTableButton);
        catalogLevelButtons.add(this.includeColumnButton);
        catalogLevelButtons.add(this.excludeColumnButton);
        catalogLevelButtons.add(this.includeProcedureButton);
        catalogLevelButtons.add(this.excludeProcedureButton);
        ArrayList<JButton> schemaLevelButtons = new ArrayList<JButton>();
        schemaLevelButtons.add(this.includeTableButton);
        schemaLevelButtons.add(this.excludeTableButton);
        schemaLevelButtons.add(this.includeColumnButton);
        schemaLevelButtons.add(this.excludeColumnButton);
        schemaLevelButtons.add(this.includeProcedureButton);
        schemaLevelButtons.add(this.excludeProcedureButton);
        ArrayList<JButton> includeTableLevelButtons = new ArrayList<JButton>();
        includeTableLevelButtons.add(this.includeColumnButton);
        includeTableLevelButtons.add(this.excludeColumnButton);
        this.levels.put(ReverseEngineering.class, rootLevelButtons);
        this.levels.put(Catalog.class, catalogLevelButtons);
        this.levels.put(Schema.class, schemaLevelButtons);
        this.levels.put(IncludeTable.class, includeTableLevelButtons);
    }

    private void addButtons() {
        this.setFloatable(false);
        this.add(this.catalogButton);
        this.add(this.schemaButton);
        this.addSeparator();
        this.add(this.includeTableButton);
        this.add(this.excludeTableButton);
        this.add(this.includeColumnButton);
        this.add(this.excludeColumnButton);
        this.add(this.includeProcedureButton);
        this.add(this.excludeProcedureButton);
        this.add(this.editButton);
        this.add(this.sortButton);
        this.addSeparator();
        this.add(this.deleteButton);
        this.add(this.configureButton);
    }

    void changeToolbarButtonsState(boolean state) {
        this.schemaButton.setEnabled(state);
        this.catalogButton.setEnabled(state);
        this.includeTableButton.setEnabled(state);
        this.excludeTableButton.setEnabled(state);
        this.includeColumnButton.setEnabled(state);
        this.excludeColumnButton.setEnabled(state);
        this.includeProcedureButton.setEnabled(state);
        this.excludeProcedureButton.setEnabled(state);
        this.editButton.setEnabled(state);
        this.deleteButton.setEnabled(state);
    }

    private void lockButtons(Object userObject) {
        this.changeToolbarButtonsState(false);
        List<JButton> buttons = this.levels.get(userObject.getClass());
        for (JButton button : buttons) {
            button.setEnabled(true);
        }
        this.editButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private void createButtons(DraggableTreePanel panel) {
        this.schemaButton = this.createButton(AddSchemaAction.class, 0);
        this.catalogButton = this.createButton(AddCatalogAction.class, 0);
        this.includeTableButton = this.createButton(AddIncludeTableAction.class, 1);
        this.excludeTableButton = this.createButton(AddExcludeTableAction.class, 2, ExcludeTable.class);
        this.includeColumnButton = this.createButton(AddIncludeColumnAction.class, 2, IncludeColumn.class);
        this.excludeColumnButton = this.createButton(AddExcludeColumnAction.class, 2, ExcludeColumn.class);
        this.includeProcedureButton = this.createButton(AddIncludeProcedureAction.class, 2, IncludeProcedure.class);
        this.excludeProcedureButton = this.createButton(AddExcludeProcedureAction.class, 3, ExcludeProcedure.class);
        this.sortButton = this.createButton(SortNodesAction.class, 0);
        this.editButton = this.createButton(EditNodeAction.class, 0);
        this.deleteButton = this.createDeleteButton(panel);
        this.configureButton = this.createConfigureButton();
    }

    private <T extends TreeManipulationAction> JButton createButton(Class<T> actionClass, int position) {
        TreeManipulationAction action = (TreeManipulationAction)this.projectController.getApplication().getActionManager().getAction(actionClass);
        action.setTree(this.reverseEngineeringTree);
        return action.buildButton(position);
    }

    private <T extends AddPatternParamAction> JButton createButton(Class<T> actionClass, int position, Class paramClass) {
        AddPatternParamAction action = (AddPatternParamAction)this.projectController.getApplication().getActionManager().getAction(actionClass);
        action.setTree(this.reverseEngineeringTree);
        action.setParamClass(paramClass);
        return action.buildButton(position);
    }

    private JButton createConfigureButton() {
        GetDbConnectionAction action = this.projectController.getApplication().getActionManager().getAction(GetDbConnectionAction.class);
        return action.buildButton(0);
    }

    private JButton createDeleteButton(DraggableTreePanel panel) {
        DeleteNodeAction deleteNodeAction = this.projectController.getApplication().getActionManager().getAction(DeleteNodeAction.class);
        deleteNodeAction.setTree(this.reverseEngineeringTree);
        deleteNodeAction.setPanel(panel);
        return deleteNodeAction.buildButton(0);
    }
}

