/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.basic.BasicGraphTransferable;

public class GraphTransferable
extends BasicGraphTransferable
implements Serializable,
ClipboardOwner {
    public static DataFlavor dataFlavor;
    protected Object[] cells;
    protected ConnectionSet cs;
    protected ParentMap pm;
    protected Map attributeMap;
    protected Rectangle2D bounds;

    public GraphTransferable(Object[] objectArray, Map map, Rectangle2D rectangle2D, ConnectionSet connectionSet, ParentMap parentMap) {
        this.attributeMap = map;
        this.bounds = rectangle2D;
        this.cells = objectArray;
        this.cs = connectionSet;
        this.pm = parentMap;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public ConnectionSet getConnectionSet() {
        return this.cs;
    }

    public ParentMap getParentMap() {
        return this.pm;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public DataFlavor[] getRicherFlavors() {
        return new DataFlavor[]{dataFlavor};
    }

    public Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(GraphTransferable.dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public boolean isPlainSupported() {
        return this.cells != null && this.cells.length == 1;
    }

    public String getPlainData() {
        Object object;
        if (this.cells[0] instanceof DefaultGraphCell && (object = ((DefaultGraphCell)this.cells[0]).getUserObject()) != null) {
            return object.toString();
        }
        return this.cells[0].toString();
    }

    public boolean isHTMLSupported() {
        return this.isPlainSupported();
    }

    public String getHTMLData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p>");
        stringBuffer.append(this.getPlainData());
        stringBuffer.append("</p></body></html>");
        return stringBuffer.toString();
    }

    static {
        DataFlavor dataFlavor;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=org.jgraph.graph.GraphTransferable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            dataFlavor = null;
        }
        GraphTransferable.dataFlavor = dataFlavor;
    }
}

