/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.Md5Crypt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Apr1CryptTest {
    Apr1CryptTest() {
    }

    @Test
    void testApr1CryptBytes() {
        byte[] keyBytes = new byte[]{33, 98, 99, 46};
        String hash = Md5Crypt.apr1Crypt((byte[])keyBytes);
        Assertions.assertEquals((Object)hash, (Object)Md5Crypt.apr1Crypt((String)"!bc.", (String)hash));
        Assertions.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"$apr1$foo"));
        Assertions.assertEquals((Object)"$apr1$./$EeFrYzWWbmTyGdf4xULYc.", (Object)Md5Crypt.apr1Crypt((String)"t\u00e4st", (String)"$apr1$./$"));
        Assertions.assertEquals((Object)"$apr1$./$kCwT1pY9qXAJElYG9q1QE1", (Object)Md5Crypt.apr1Crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"$apr1$./$"));
    }

    @Test
    void testApr1CryptBytesWithThreadLocalRandom() {
        byte[] keyBytes = new byte[]{33, 98, 99, 46};
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        String hash = Md5Crypt.apr1Crypt((byte[])keyBytes, (Random)threadLocalRandom);
        Assertions.assertEquals((Object)hash, (Object)Md5Crypt.apr1Crypt((String)"!bc.", (String)hash));
        Assertions.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"$apr1$foo"));
        Assertions.assertEquals((Object)"$apr1$./$EeFrYzWWbmTyGdf4xULYc.", (Object)Md5Crypt.apr1Crypt((String)"t\u00e4st", (String)"$apr1$./$"));
        Assertions.assertEquals((Object)"$apr1$./$kCwT1pY9qXAJElYG9q1QE1", (Object)Md5Crypt.apr1Crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"$apr1$./$"));
    }

    @Test
    void testApr1CryptExplicitCall() {
        Assertions.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"1234"));
        Assertions.assertTrue((boolean)Md5Crypt.apr1Crypt((byte[])"secret".getBytes()).matches("^\\$apr1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
        Assertions.assertTrue((boolean)Md5Crypt.apr1Crypt((byte[])"secret".getBytes(), (String)null).matches("^\\$apr1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
    }

    @Test
    void testApr1CryptNullData() {
        Assertions.assertThrows(NullPointerException.class, () -> Md5Crypt.apr1Crypt((byte[])null));
    }

    @Test
    void testApr1CryptStrings() {
        Assertions.assertEquals((Object)"$apr1$TqI9WECO$LHZB2DqRlk9nObiB6vJG9.", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$TqI9WECO"));
        Assertions.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((String)"", (String)"$apr1$foo"));
        Assertions.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234"));
        Assertions.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234$567"));
        Assertions.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234$567$890"));
        Assertions.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234567890123456"));
        Assertions.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$123456789012345678"));
    }

    @Test
    void testApr1CryptWithEmptySalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.apr1Crypt((byte[])"secret".getBytes(), (String)""));
    }

    @Test
    void testApr1CryptWithInvalidSalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"!"));
    }

    @Test
    void testApr1CryptWithoutSalt() {
        String hash = Md5Crypt.apr1Crypt((String)"secret");
        Assertions.assertTrue((boolean)hash.matches("^\\$apr1\\$[a-zA-Z0-9\\./]{8}\\$[a-zA-Z0-9\\./]{22}$"));
        String hash2 = Md5Crypt.apr1Crypt((String)"secret");
        Assertions.assertNotSame((Object)hash, (Object)hash2);
    }

    @Test
    void testApr1LongSalt() {
        Assertions.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"12345678901234567890"));
    }
}

