/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.TestBean;

public class BasicRowProcessorTest
extends BaseTestCase {
    private static final RowProcessor processor = new BasicRowProcessor();
    private static final DateFormat datef = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);

    public void testPutAllContainsKeyAndRemove() throws Exception {
        HashMap<String, String> test = new HashMap<String, String>(3);
        test.put("fiRst", "thing");
        test.put("seCond", "another");
        test.put("thIrd", "more");
        Map brpMap = BasicRowProcessor.createCaseInsensitiveHashMap((int)3);
        brpMap.putAll(test);
        BasicRowProcessorTest.assertEquals(test, (Object)brpMap);
        BasicRowProcessorTest.assertTrue((boolean)brpMap.containsKey("fiRst"));
        BasicRowProcessorTest.assertTrue((boolean)brpMap.containsKey("first"));
        brpMap.remove("first");
        BasicRowProcessorTest.assertFalse((boolean)brpMap.containsKey("first"));
    }

    public void testToArray() throws SQLException {
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        Object[] a = processor.toArray(this.rs);
        BasicRowProcessorTest.assertEquals((int)COLS, (int)a.length);
        BasicRowProcessorTest.assertEquals((Object)"1", (Object)a[0]);
        BasicRowProcessorTest.assertEquals((Object)"2", (Object)a[1]);
        BasicRowProcessorTest.assertEquals((Object)"THREE", (Object)a[2]);
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        a = processor.toArray(this.rs);
        BasicRowProcessorTest.assertEquals((int)COLS, (int)a.length);
        BasicRowProcessorTest.assertEquals((Object)"4", (Object)a[0]);
        BasicRowProcessorTest.assertEquals((Object)"5", (Object)a[1]);
        BasicRowProcessorTest.assertEquals((Object)"SIX", (Object)a[2]);
        BasicRowProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testToBean() throws SQLException, ParseException {
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        TestBean row = (TestBean)processor.toBean(this.rs, TestBean.class);
        BasicRowProcessorTest.assertEquals((String)"1", (String)row.getOne());
        BasicRowProcessorTest.assertEquals((String)"2", (String)row.getTwo());
        BasicRowProcessorTest.assertEquals((Object)((Object)TestBean.Ordinal.THREE), (Object)((Object)row.getThree()));
        BasicRowProcessorTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        row = (TestBean)processor.toBean(this.rs, TestBean.class);
        BasicRowProcessorTest.assertEquals((String)"4", (String)row.getOne());
        BasicRowProcessorTest.assertEquals((String)"5", (String)row.getTwo());
        BasicRowProcessorTest.assertEquals((Object)((Object)TestBean.Ordinal.SIX), (Object)((Object)row.getThree()));
        BasicRowProcessorTest.assertEquals((String)"not set", (String)row.getDoNotSet());
        BasicRowProcessorTest.assertEquals((int)3, (int)row.getIntTest());
        BasicRowProcessorTest.assertEquals((Object)4, (Object)row.getIntegerTest());
        BasicRowProcessorTest.assertEquals(null, (Object)row.getNullObjectTest());
        BasicRowProcessorTest.assertEquals((int)0, (int)row.getNullPrimitiveTest());
        BasicRowProcessorTest.assertNotNull((Object)row.getNotDate());
        BasicRowProcessorTest.assertTrue((!"not a date".equals(row.getNotDate()) ? 1 : 0) != 0);
        BasicRowProcessorTest.assertTrue((boolean)row.getNotDate().endsWith("789456123"));
        BasicRowProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testToBeanList() throws SQLException, ParseException {
        List list = processor.toBeanList(this.rs, TestBean.class);
        BasicRowProcessorTest.assertNotNull((Object)list);
        BasicRowProcessorTest.assertEquals((int)ROWS, (int)list.size());
        TestBean b = (TestBean)list.get(0);
        BasicRowProcessorTest.assertEquals((String)"1", (String)b.getOne());
        BasicRowProcessorTest.assertEquals((String)"2", (String)b.getTwo());
        BasicRowProcessorTest.assertEquals((Object)((Object)TestBean.Ordinal.THREE), (Object)((Object)b.getThree()));
        BasicRowProcessorTest.assertEquals((String)"not set", (String)b.getDoNotSet());
        datef.parse(b.getNotDate());
        b = (TestBean)list.get(1);
        BasicRowProcessorTest.assertEquals((String)"4", (String)b.getOne());
        BasicRowProcessorTest.assertEquals((String)"5", (String)b.getTwo());
        BasicRowProcessorTest.assertEquals((Object)((Object)TestBean.Ordinal.SIX), (Object)((Object)b.getThree()));
        BasicRowProcessorTest.assertEquals((String)"not set", (String)b.getDoNotSet());
        BasicRowProcessorTest.assertEquals((int)3, (int)b.getIntTest());
        BasicRowProcessorTest.assertEquals((Object)4, (Object)b.getIntegerTest());
        BasicRowProcessorTest.assertEquals(null, (Object)b.getNullObjectTest());
        BasicRowProcessorTest.assertEquals((int)0, (int)b.getNullPrimitiveTest());
        BasicRowProcessorTest.assertNotNull((Object)b.getNotDate());
        BasicRowProcessorTest.assertTrue((!"not a date".equals(b.getNotDate()) ? 1 : 0) != 0);
        BasicRowProcessorTest.assertTrue((boolean)b.getNotDate().endsWith("789456123"));
    }

    public void testToMap() throws SQLException {
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        Map m = processor.toMap(this.rs);
        BasicRowProcessorTest.assertEquals((int)COLS, (int)m.size());
        BasicRowProcessorTest.assertEquals((Object)"1", m.get("one"));
        BasicRowProcessorTest.assertEquals((Object)"2", m.get("TWO"));
        BasicRowProcessorTest.assertEquals((Object)"THREE", m.get("Three"));
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        m = processor.toMap(this.rs);
        BasicRowProcessorTest.assertEquals((int)COLS, (int)m.size());
        BasicRowProcessorTest.assertEquals((Object)"4", m.get("One"));
        BasicRowProcessorTest.assertEquals((Object)"5", m.get("two"));
        BasicRowProcessorTest.assertEquals((Object)"SIX", m.get("THREE"));
        BasicRowProcessorTest.assertFalse((boolean)this.rs.next());
    }

    public void testToMapOrdering() throws SQLException {
        BasicRowProcessorTest.assertTrue((boolean)this.rs.next());
        Map m = processor.toMap(this.rs);
        Iterator itr = m.keySet().iterator();
        BasicRowProcessorTest.assertEquals((String)"one", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"two", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"three", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"notInBean", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"intTest", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"integerTest", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"nullObjectTest", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"nullPrimitiveTest", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"notDate", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"columnProcessorDoubleTest", (String)((String)itr.next()));
        BasicRowProcessorTest.assertEquals((String)"11", (String)((String)itr.next()));
        BasicRowProcessorTest.assertFalse((boolean)itr.hasNext());
    }
}

