/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.SimpleTextParser;
import org.apache.commons.geometry.io.euclidean.threed.obj.AbstractObjParser;

public class PolygonObjParser
extends AbstractObjParser {
    private static final Set<String> STANDARD_POLYGON_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("v", "vn", "vt", "f", "o", "g", "s", "mtllib", "usemtl")));
    private int vertexCount;
    private int vertexNormalCount;
    private int textureCoordinateCount;
    private boolean failOnNonPolygonKeywords;

    public PolygonObjParser(Reader reader) {
        this(new SimpleTextParser(reader));
    }

    public PolygonObjParser(SimpleTextParser parser) {
        super(parser);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int getVertexNormalCount() {
        return this.vertexNormalCount;
    }

    public int getTextureCoordinateCount() {
        return this.textureCoordinateCount;
    }

    public boolean isFailOnNonPolygonKeywords() {
        return this.failOnNonPolygonKeywords;
    }

    public void setFailOnNonPolygonKeywords(boolean failOnNonPolygonKeywords) {
        this.failOnNonPolygonKeywords = failOnNonPolygonKeywords;
    }

    @Override
    protected void handleKeyword(String keywordValue) {
        if (this.failOnNonPolygonKeywords && !STANDARD_POLYGON_KEYWORDS.contains(keywordValue)) {
            String allowedKeywords = STANDARD_POLYGON_KEYWORDS.stream().sorted().collect(Collectors.joining(", "));
            throw this.getTextParser().tokenError("expected keyword to be one of [" + allowedKeywords + "] but was [" + keywordValue + "]");
        }
        switch (keywordValue) {
            case "v": {
                ++this.vertexCount;
                break;
            }
            case "vn": {
                ++this.vertexNormalCount;
                break;
            }
            case "vt": {
                ++this.textureCoordinateCount;
                break;
            }
        }
    }

    public Face readFace() {
        ArrayList<VertexAttributes> vertices = new ArrayList<VertexAttributes>();
        while (this.nextDataLineContent()) {
            vertices.add(this.readFaceVertex());
        }
        if (vertices.size() < 3) {
            throw this.getTextParser().parseError("face must contain at least 3 vertices but found only " + vertices.size());
        }
        this.discardDataLine();
        return new Face(vertices);
    }

    private VertexAttributes readFaceVertex() {
        SimpleTextParser parser = this.getTextParser();
        this.discardDataLineWhitespace();
        int vertexIndex = this.readNormalizedVertexAttributeIndex("vertex", this.vertexCount);
        int textureIndex = -1;
        if (parser.peekChar() == 47) {
            parser.discard(1);
            if (parser.peekChar() != 47) {
                textureIndex = this.readNormalizedVertexAttributeIndex("texture", this.textureCoordinateCount);
            }
        }
        int normalIndex = -1;
        if (parser.peekChar() == 47) {
            parser.discard(1);
            if (SimpleTextParser.isIntegerPart((int)parser.peekChar())) {
                normalIndex = this.readNormalizedVertexAttributeIndex("normal", this.vertexNormalCount);
            }
        }
        return new VertexAttributes(vertexIndex, textureIndex, normalIndex);
    }

    private int readNormalizedVertexAttributeIndex(String type, int available) {
        int normalizedIndex;
        SimpleTextParser parser = this.getTextParser();
        int objIndex = parser.nextWithLineContinuation('\\', SimpleTextParser::isIntegerPart).getCurrentTokenAsInt();
        int n = normalizedIndex = objIndex < 0 ? available + objIndex : objIndex - 1;
        if (normalizedIndex < 0 || normalizedIndex >= available) {
            StringBuilder err = new StringBuilder();
            err.append(type).append(" index ");
            if (available < 1) {
                err.append("cannot be used because no values of that type have been defined");
            } else {
                err.append("must evaluate to be within the range [1, ").append(available).append("] but was ").append(objIndex);
            }
            throw parser.tokenError(err.toString());
        }
        return normalizedIndex;
    }

    public static final class VertexAttributes {
        private final int vertexIndex;
        private final int textureIndex;
        private final int normalIndex;

        VertexAttributes(int vertexIndex, int textureIndex, int normalIndex) {
            this.vertexIndex = vertexIndex;
            this.textureIndex = textureIndex;
            this.normalIndex = normalIndex;
        }

        public int getVertexIndex() {
            return this.vertexIndex;
        }

        public int getTextureIndex() {
            return this.textureIndex;
        }

        public int getNormalIndex() {
            return this.normalIndex;
        }
    }

    public static final class Face {
        private final List<VertexAttributes> vertexAttributes;

        Face(List<VertexAttributes> vertexAttributes) {
            this.vertexAttributes = Collections.unmodifiableList(vertexAttributes);
        }

        public List<VertexAttributes> getVertexAttributes() {
            return this.vertexAttributes;
        }

        public Vector3D getDefinedCompositeNormal(IntFunction<Vector3D> modelNormalFn) {
            Vector3D sum = Vector3D.ZERO;
            for (VertexAttributes vertex : this.vertexAttributes) {
                int normalIdx = vertex.getNormalIndex();
                if (normalIdx <= -1) continue;
                sum = sum.add(modelNormalFn.apply(normalIdx));
            }
            return sum.normalizeOrNull();
        }

        public Vector3D computeNormalFromVertices(IntFunction<Vector3D> modelVertexFn) {
            Vector3D p0 = modelVertexFn.apply(this.vertexAttributes.get(0).getVertexIndex());
            Vector3D p1 = modelVertexFn.apply(this.vertexAttributes.get(1).getVertexIndex());
            Vector3D p2 = modelVertexFn.apply(this.vertexAttributes.get(2).getVertexIndex());
            return p0.vectorTo(p1).cross(p0.vectorTo(p2)).normalizeOrNull();
        }

        public List<VertexAttributes> getVertexAttributesCounterClockwise(Vector3D normal, IntFunction<Vector3D> modelVertexFn) {
            Vector3D computedNormal;
            List<VertexAttributes> result = this.vertexAttributes;
            if (normal != null && (computedNormal = this.computeNormalFromVertices(modelVertexFn)) != null && normal.dot(computedNormal) < 0.0) {
                result = new ArrayList<VertexAttributes>(this.vertexAttributes);
                Collections.reverse(result);
            }
            return result;
        }

        public List<Vector3D> getVertices(IntFunction<Vector3D> modelVertexFn) {
            return this.vertexAttributes.stream().map(v -> (Vector3D)modelVertexFn.apply(v.getVertexIndex())).collect(Collectors.toList());
        }

        public List<Vector3D> getVerticesCounterClockwise(Vector3D normal, IntFunction<Vector3D> modelVertexFn) {
            return this.getVertexAttributesCounterClockwise(normal, modelVertexFn).stream().map(v -> (Vector3D)modelVertexFn.apply(v.getVertexIndex())).collect(Collectors.toList());
        }

        public int[] getVertexIndices() {
            return this.getIndices(VertexAttributes::getVertexIndex);
        }

        public int[] getTextureIndices() {
            return this.getIndices(VertexAttributes::getTextureIndex);
        }

        public int[] getNormalIndices() {
            return this.getIndices(VertexAttributes::getNormalIndex);
        }

        private int[] getIndices(ToIntFunction<VertexAttributes> fn) {
            int len = this.vertexAttributes.size();
            int[] indices = new int[len];
            for (int i = 0; i < len; ++i) {
                indices[i] = fn.applyAsInt(this.vertexAttributes.get(i));
            }
            return indices;
        }
    }
}

