/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import org.apache.commons.geometry.spherical.oned.CutAngle;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.numbers.core.Precision;

public final class CutAngles {
    private CutAngles() {
    }

    public static CutAngle fromAzimuthAndDirection(double azimuth, boolean positiveFacing, Precision.DoubleEquivalence precision) {
        return CutAngles.fromPointAndDirection(Point1S.of(azimuth), positiveFacing, precision);
    }

    public static CutAngle fromPointAndDirection(Point1S point, boolean positiveFacing, Precision.DoubleEquivalence precision) {
        return new CutAngle(point, positiveFacing, precision);
    }

    public static CutAngle createPositiveFacing(double azimuth, Precision.DoubleEquivalence precision) {
        return CutAngles.createPositiveFacing(Point1S.of(azimuth), precision);
    }

    public static CutAngle createPositiveFacing(Point1S point, Precision.DoubleEquivalence precision) {
        return CutAngles.fromPointAndDirection(point, true, precision);
    }

    public static CutAngle createNegativeFacing(double azimuth, Precision.DoubleEquivalence precision) {
        return CutAngles.createNegativeFacing(Point1S.of(azimuth), precision);
    }

    public static CutAngle createNegativeFacing(Point1S point, Precision.DoubleEquivalence precision) {
        return CutAngles.fromPointAndDirection(point, false, precision);
    }
}

