/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

final class PngCrc {
    private final long[] crcTable = new long[256];
    private boolean crcTableComputed;

    PngCrc() {
    }

    public long continuePartialCrc(long oldCrc, byte[] buf, int len) {
        return this.updateCrc(oldCrc, buf);
    }

    public int crc(byte[] buf, int len) {
        return (int)(this.updateCrc(0xFFFFFFFFL, buf) ^ 0xFFFFFFFFL);
    }

    public long finishPartialCrc(long oldCrc) {
        return oldCrc ^ 0xFFFFFFFFL;
    }

    private void makeCrcTable() {
        for (int n = 0; n < 256; ++n) {
            long c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1L) != 0L) {
                    c = 0xEDB88320L ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            this.crcTable[n] = c;
        }
        this.crcTableComputed = true;
    }

    public long startPartialCrc(byte[] buf, int len) {
        return this.updateCrc(0xFFFFFFFFL, buf);
    }

    private long updateCrc(long crc, byte[] buf) {
        long c = crc;
        if (!this.crcTableComputed) {
            this.makeCrcTable();
        }
        for (int n = 0; n < buf.length; ++n) {
            c = this.crcTable[(int)((c ^ (long)buf[n]) & 0xFFL)] ^ c >> 8;
        }
        return c;
    }
}

