/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;

public abstract class AbstractCompilerTestCase
extends TestCase {
    public abstract JavaCompiler createJavaCompiler();

    public abstract String getCompilerName();

    public void testFactoryCreation() {
        JavaCompiler factoryCompiler = new JavaCompilerFactory().createCompiler(this.getCompilerName());
        AbstractCompilerTestCase.assertNotNull((Object)factoryCompiler);
        JavaCompiler compiler = this.createJavaCompiler();
        AbstractCompilerTestCase.assertEquals((String)factoryCompiler.getClass().getName(), (String)compiler.getClass().getName());
    }

    public void testSimpleCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Simple.java", "package jci;\npublic class Simple {\n  public String toString() {\n    return \"Simple\";\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Simple.java"}, reader, (ResourceStore)store);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytes = store.read("jci/Simple.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Simple.class is not null", (Object)clazzBytes);
        AbstractCompilerTestCase.assertTrue((String)"jci/Simple.class is not empty", (clazzBytes.length > 0 ? 1 : 0) != 0);
    }

    public void testExtendedCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Simple.java", "package jci;\npublic class Simple {\n  public String toString() {\n    return \"Simple\";\n  }\n}".getBytes());
                    this.put("jci/Extended.java", "package jci;\npublic class Extended extends Simple {\n  public String toString() {\n    return \"Extended\" + super.toString();\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Extended.java", "jci/Simple.java"}, reader, (ResourceStore)store);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytesSimple = store.read("jci/Simple.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Simple.class is not null", (Object)clazzBytesSimple);
        AbstractCompilerTestCase.assertTrue((String)"jci/Simple.class is not empty", (clazzBytesSimple.length > 0 ? 1 : 0) != 0);
        byte[] clazzBytesExtended = store.read("jci/Extended.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Extended.class is not null", (Object)clazzBytesExtended);
        AbstractCompilerTestCase.assertTrue((String)"jci/Extended.class is not empty", (clazzBytesExtended.length > 0 ? 1 : 0) != 0);
    }

    public void testInternalClassCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Simple.java", "package jci;\npublic class Simple {\n  private class Sub {\n  }\n  public String toString() {\n    new Sub();\n    return \"Simple\";\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Simple.java"}, reader, (ResourceStore)store);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytes = store.read("jci/Simple.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Simple.class is not null", (Object)clazzBytes);
        AbstractCompilerTestCase.assertTrue((String)"jci/Simple.class is not empty", (clazzBytes.length > 0 ? 1 : 0) != 0);
        byte[] subClazzBytes = store.read("jci/Simple$Sub.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Simple$Sub.class is not null", (Object)subClazzBytes);
        AbstractCompilerTestCase.assertTrue((String)"jci/Simple$Sub.class is not empty", (subClazzBytes.length > 0 ? 1 : 0) != 0);
    }

    public void testUppercasePackageNameCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("Jci/Simple.java", "package Jci;\npublic class Simple {\n  public String toString() {\n    return \"Simple\";\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"Jci/Simple.java"}, reader, (ResourceStore)store);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytes = store.read("Jci/Simple.class");
        AbstractCompilerTestCase.assertNotNull((String)"Jci/Simple.class is not null", (Object)clazzBytes);
        AbstractCompilerTestCase.assertTrue((String)"Jci/Simple.class is not empty", (clazzBytes.length > 0 ? 1 : 0) != 0);
    }

    public void testCrossReferenceCompilation() throws Exception {
        String javaVersion = System.getProperty("java.version");
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Func1.java", "package jci;\nimport static jci.Func2.func2;public class Func1 {\n  public static boolean func1() throws Exception {\n    return true;\n  }\n}".getBytes());
                    this.put("jci/Func2.java", "package jci;\nimport static jci.Func1.func1;public class Func2 {\n  public static boolean func2() throws Exception {\n    return true;\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        JavaCompilerSettings settings = compiler.createDefaultSettings();
        settings.setTargetVersion("1.5");
        settings.setSourceVersion("1.5");
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Func1.java", "jci/Func2.java"}, reader, (ResourceStore)store, ((Object)((Object)this)).getClass().getClassLoader(), settings);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        AbstractCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytesFunc1 = store.read("jci/Func1.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Func1.class is not null", (Object)clazzBytesFunc1);
        AbstractCompilerTestCase.assertTrue((String)"jci/Func1.class is not empty", (clazzBytesFunc1.length > 0 ? 1 : 0) != 0);
        byte[] clazzBytesFunc2 = store.read("jci/Func2.class");
        AbstractCompilerTestCase.assertNotNull((String)"jci/Func2.class is not null", (Object)clazzBytesFunc2);
        AbstractCompilerTestCase.assertTrue((String)"jci/Func2.class is not empty", (clazzBytesFunc2.length > 0 ? 1 : 0) != 0);
    }

    public void testAdditionalTopLevelClassCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Simple.java", "package jci;\npublic class Simple {\n  public String toString() {\n    return \"Simple\";\n  }\n}\nclass AdditionalTopLevel {\n  public String toString() {\n    return \"AdditionalTopLevel\";\n  }\n}".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Simple.java"}, reader, (ResourceStore)store);
        AbstractCompilerTestCase.assertEquals((String)("Unexpected errors(s): " + this.toString(result.getErrors())), (int)0, (int)result.getErrors().length);
        byte[] clazzBytes = store.read("jci/Simple.class");
        AbstractCompilerTestCase.assertNotNull((String)"Expected to find jci/Simple.class", (Object)clazzBytes);
        AbstractCompilerTestCase.assertTrue((clazzBytes.length > 0 ? 1 : 0) != 0);
        byte[] additionalTopLevelBytes = store.read("jci/AdditionalTopLevel.class");
        AbstractCompilerTestCase.assertNotNull((String)"Expected to find jci/AdditionalTopLevel.class", (Object)additionalTopLevelBytes);
        AbstractCompilerTestCase.assertTrue((additionalTopLevelBytes.length > 0 ? 1 : 0) != 0);
        AbstractCompilerTestCase.assertEquals((String)("Unexpected warning(s): " + this.toString(result.getWarnings())), (int)0, (int)result.getWarnings().length);
    }

    public final String toString(CompilationProblem[] pProblems) {
        StringBuilder sb = new StringBuilder();
        for (CompilationProblem problem : pProblems) {
            sb.append(problem.getMessage()).append(", ");
        }
        return sb.toString();
    }
}

