/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.log;

import java.util.function.Supplier;
import org.apache.commons.jcs3.log.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Log4j2LogAdapter
implements Log {
    private final Logger logger;

    public Log4j2LogAdapter(Logger logger) {
        this.logger = logger;
    }

    private void log(Level level, String message, Supplier<?> ... paramSuppliers) {
        if (this.logger.isEnabled(level)) {
            if (paramSuppliers == null) {
                this.logger.log(level, message);
            } else {
                switch (paramSuppliers.length) {
                    case 1: {
                        this.logger.log(level, message, paramSuppliers[0].get());
                        break;
                    }
                    case 2: {
                        this.logger.log(level, message, paramSuppliers[0].get(), paramSuppliers[1].get());
                        break;
                    }
                    case 3: {
                        this.logger.log(level, message, paramSuppliers[0].get(), paramSuppliers[1].get(), paramSuppliers[2].get());
                        break;
                    }
                    case 4: {
                        this.logger.log(level, message, paramSuppliers[0].get(), paramSuppliers[1].get(), paramSuppliers[2].get(), paramSuppliers[3].get());
                        break;
                    }
                    case 5: {
                        this.logger.log(level, message, paramSuppliers[0].get(), paramSuppliers[1].get(), paramSuppliers[2].get(), paramSuppliers[3].get(), paramSuppliers[4].get());
                        break;
                    }
                    default: {
                        this.logger.log(level, message, paramSuppliers[0].get(), paramSuppliers[1].get(), paramSuppliers[2].get(), paramSuppliers[3].get(), paramSuppliers[4].get(), paramSuppliers[5].get());
                    }
                }
            }
        }
    }

    @Override
    public void debug(String message) {
        this.logger.debug(message);
    }

    @Override
    public void debug(Object message) {
        this.logger.debug(message);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.logger.debug(message, params);
    }

    @Override
    public void debug(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.DEBUG, message, paramSuppliers);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logger.debug(message, t);
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public void error(Object message) {
        this.logger.error(message);
    }

    @Override
    public void error(String message, Object ... params) {
        this.logger.error(message, params);
    }

    @Override
    public void error(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.ERROR, message, paramSuppliers);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logger.error(message, t);
    }

    @Override
    public void fatal(String message) {
        this.logger.fatal(message);
    }

    @Override
    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    @Override
    public void fatal(String message, Object ... params) {
        this.logger.fatal(message, params);
    }

    @Override
    public void fatal(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.FATAL, message, paramSuppliers);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.logger.fatal(message, t);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void info(Object message) {
        this.logger.info(message);
    }

    @Override
    public void info(String message, Object ... params) {
        this.logger.info(message, params);
    }

    @Override
    public void info(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.INFO, message, paramSuppliers);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logger.info(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void trace(String message) {
        this.logger.trace(message);
    }

    @Override
    public void trace(Object message) {
        this.logger.trace(message);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.logger.trace(message, params);
    }

    @Override
    public void trace(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.TRACE, message, paramSuppliers);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.logger.trace(message, t);
    }

    @Override
    public void warn(String message) {
        this.logger.warn(message);
    }

    @Override
    public void warn(Object message) {
        this.logger.warn(message);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.logger.warn(message, params);
    }

    @Override
    public void warn(String message, Supplier<?> ... paramSuppliers) {
        this.log(Level.WARN, message, paramSuppliers);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logger.warn(message, t);
    }
}

