/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestGenericObjectPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBaseGenericObjectPool {
    BaseGenericObjectPool<String> pool = null;
    TestGenericObjectPool.SimpleFactory factory = null;

    @Before
    public void setUp() throws Exception {
        this.factory = new TestGenericObjectPool.SimpleFactory();
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory);
    }

    @After
    public void tearDown() throws Exception {
        this.pool.close();
        this.pool = null;
        this.factory = null;
    }

    @Test
    public void testBorrowWaitStatistics() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        this.pool.updateStatsBorrow((PooledObject)p, 10L);
        this.pool.updateStatsBorrow((PooledObject)p, 20L);
        this.pool.updateStatsBorrow((PooledObject)p, 20L);
        this.pool.updateStatsBorrow((PooledObject)p, 30L);
        Assert.assertEquals((double)20.0, (double)this.pool.getMeanBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        Assert.assertEquals((float)30.0f, (float)this.pool.getMaxBorrowWaitTimeMillis(), (float)0.0f);
    }

    public void testBorrowWaitStatisticsMax() {
        DefaultPooledObject p = (DefaultPooledObject)this.factory.makeObject();
        Assert.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, 0L);
        Assert.assertEquals((double)0.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, 20L);
        Assert.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, 20L);
        Assert.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
        this.pool.updateStatsBorrow((PooledObject)p, 10L);
        Assert.assertEquals((double)20.0, (double)this.pool.getMaxBorrowWaitTimeMillis(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testActiveTimeStatistics() {
        for (int i = 0; i < 99; ++i) {
            this.pool.updateStatsReturn((long)i);
        }
        Assert.assertEquals((double)49.0, (double)this.pool.getMeanActiveTimeMillis(), (double)Double.MIN_VALUE);
    }
}

