/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.PermutationSampler;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.SubsetSamplerUtils;

public class CombinationSampler
implements SharedStateObjectSampler<int[]> {
    private final int[] domain;
    private final int steps;
    private final boolean upper;
    private final UniformRandomProvider rng;

    public CombinationSampler(UniformRandomProvider rng, int n, int k) {
        SubsetSamplerUtils.checkSubset(n, k);
        this.domain = PermutationSampler.natural(n);
        this.upper = k <= n / 2;
        this.steps = this.upper ? k : n - k;
        this.rng = rng;
    }

    private CombinationSampler(UniformRandomProvider rng, CombinationSampler source) {
        this.domain = PermutationSampler.natural(source.domain.length);
        this.steps = source.steps;
        this.upper = source.upper;
        this.rng = rng;
    }

    @Override
    public int[] sample() {
        return SubsetSamplerUtils.partialSample(this.domain, this.steps, this.rng, this.upper);
    }

    @Override
    public CombinationSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new CombinationSampler(rng, this);
    }
}

