/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpFilesCacheTest {
    @Test
    public void testQueryStringUrls() throws FileSystemException {
        String noQueryStringUrl = "http://commons.apache.org/vfs";
        String queryStringUrl = "http://commons.apache.org/vfs?query=string";
        String queryStringUrl2 = "http://commons.apache.org/vfs?query=string&more=stuff";
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject noQueryFile = fileSystemManager.resolveFile("http://commons.apache.org/vfs");){
            Assertions.assertEquals((Object)"http://commons.apache.org/vfs", (Object)noQueryFile.getURL().toExternalForm());
        }
        try (FileObject queryFile = fileSystemManager.resolveFile("http://commons.apache.org/vfs?query=string");){
            Assertions.assertEquals((Object)"http://commons.apache.org/vfs?query=string", (Object)queryFile.getURL().toExternalForm());
        }
        try (FileObject queryFile2 = fileSystemManager.resolveFile("http://commons.apache.org/vfs?query=string&more=stuff");){
            Assertions.assertEquals((Object)"http://commons.apache.org/vfs?query=string&more=stuff", (Object)queryFile2.getURL().toExternalForm());
        }
    }
}

