/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import org.apache.commons.cli.Option;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.tools.AbstractOption;
import org.apache.rat.tools.AntGenerator;

public class AntOption
extends AbstractOption {
    AntOption(Option option) {
        super(option, AntGenerator.createName(option));
    }

    public boolean isAttribute() {
        return !this.option.hasArgs();
    }

    public boolean isElement() {
        return !this.isAttribute() || this.option.getType() != String.class;
    }

    @Override
    protected String cleanupName(Option option) {
        AntOption antOption = new AntOption(option);
        String fmt = antOption.isAttribute() ? "%s attribute" : "<%s>";
        return String.format(fmt, AntGenerator.createName(option));
    }

    public String getComment(boolean addParam) {
        StringBuilder sb = new StringBuilder().append(String.format("    /**%n     * %s%n", StringEscapeUtils.escapeHtml4(this.getDescription())));
        if (this.option.isDeprecated()) {
            sb.append(String.format("     * %s%n     * @deprecated%n", this.option.getDeprecated()));
        }
        if (addParam && this.option.hasArg()) {
            sb.append(String.format("     * @param %s The value to set%n", this.name));
        }
        return sb.append(String.format("     */%n", new Object[0])).toString();
    }

    public String getAttributeFunctionName() {
        return "set" + WordUtils.capitalize(this.name) + (this.option.hasArg() ? "(String " : "(boolean ") + this.name + ")";
    }
}

