/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum ConsumerField {
    ID("id", "consumerID"),
    SEQUENTIAL_ID("sequentialId", "sequentialId"),
    SESSION("session", "sessionID"),
    CONNECTION("connection", "connectionID"),
    QUEUE("queue", "queueName"),
    FILTER("filter"),
    ADDRESS("address"),
    USER("user"),
    VALIDATED_USER("validatedUser"),
    PROTOCOL("protocol"),
    CLIENT_ID("clientID"),
    LOCAL_ADDRESS("localAddress"),
    REMOTE_ADDRESS("remoteAddress"),
    QUEUE_TYPE("queueType"),
    BROWSE_ONLY("browseOnly"),
    CREATION_TIME("creationTime"),
    MESSAGES_IN_TRANSIT("messagesInTransit", "deliveringCount"),
    MESSAGES_IN_TRANSIT_SIZE("messagesInTransitSize"),
    MESSAGES_DELIVERED("messagesDelivered"),
    MESSAGES_DELIVERED_SIZE("messagesDeliveredSize"),
    MESSAGES_ACKNOWLEDGED("messagesAcknowledged"),
    MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT("messagesAcknowledgedAwaitingCommit"),
    LAST_DELIVERED_TIME("lastDeliveredTime"),
    LAST_ACKNOWLEDGED_TIME("lastAcknowledgedTime"),
    STATUS("status");

    private static final Map<String, ConsumerField> lookup;
    private final String name;
    private final String alternativeName;

    public String getName() {
        return this.name;
    }

    public String getAlternativeName() {
        return this.alternativeName;
    }

    private ConsumerField(String name) {
        this(name, "");
    }

    private ConsumerField(String name, String alternativeName) {
        this.name = name;
        this.alternativeName = alternativeName;
    }

    public static ConsumerField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, ConsumerField>(String.CASE_INSENSITIVE_ORDER);
        for (ConsumerField e : ConsumerField.values()) {
            lookup.put(e.name, e);
        }
    }
}

