/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.quorum.Vote;

public class QuorumVoteMessage
extends PacketImpl {
    private SimpleString handler;
    private Vote vote;
    private ActiveMQBuffer voteBuffer;

    public QuorumVoteMessage() {
        super((byte)-2);
    }

    public QuorumVoteMessage(SimpleString handler, Vote vote) {
        super((byte)-2);
        this.handler = handler;
        this.vote = vote;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeSimpleString(this.handler);
        this.vote.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.handler = buffer.readSimpleString();
        this.voteBuffer = ActiveMQBuffers.fixedBuffer((int)buffer.readableBytes());
        buffer.readBytes(this.voteBuffer);
    }

    public SimpleString getHandler() {
        return this.handler;
    }

    public Vote getVote() {
        return this.vote;
    }

    public void decode(QuorumVoteHandler voteHandler) {
        this.vote = voteHandler.decode(this.voteBuffer);
    }

    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", vote=" + this.vote);
        buff.append(", handler=" + this.handler);
        return buff.toString();
    }
}

