/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ModalCloseable;
import org.slf4j.Logger;

public abstract class AbstractHttpClient
implements HttpClient,
ModalCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpClient.class);

    protected abstract ClassicHttpResponse doExecute(@Nullable HttpHost var1, @Nonnull ClassicHttpRequest var2, @Nullable HttpContext var3) throws IOException;

    private static HttpHost determineTarget(@Nullable ClassicHttpRequest request) throws ClientProtocolException {
        try {
            return RoutingSupport.determineHost((HttpRequest)request);
        }
        catch (HttpException ex) {
            throw new ClientProtocolException((Throwable)ex);
        }
    }

    public ClassicHttpResponse execute(@Nullable HttpHost target, @Nullable ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
        return this.doExecute(target, (ClassicHttpRequest)Constraint.isNotNull((Object)request, (String)"HTTP request"), context);
    }

    public ClassicHttpResponse execute(@Nullable ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
        return this.doExecute(AbstractHttpClient.determineTarget(request), (ClassicHttpRequest)Constraint.isNotNull((Object)request, (String)"HTTP request"), context);
    }

    public ClassicHttpResponse execute(@Nullable ClassicHttpRequest request) throws IOException {
        return this.doExecute(AbstractHttpClient.determineTarget(request), (ClassicHttpRequest)Constraint.isNotNull((Object)request, (String)"HTTP request"), null);
    }

    public ClassicHttpResponse execute(@Nullable HttpHost target, @Nullable ClassicHttpRequest request) throws IOException {
        return this.doExecute(target, (ClassicHttpRequest)Constraint.isNotNull((Object)request, (String)"HTTP request"), null);
    }

    public <T> T execute(@Nullable ClassicHttpRequest request, @Nullable HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        Constraint.isNotNull((Object)request, (String)"HTTP request");
        Constraint.isNotNull(responseHandler, (String)"HTTP response handler");
        return this.execute(request, null, responseHandler);
    }

    public <T> T execute(@Nullable ClassicHttpRequest request, @Nullable HttpContext context, @Nullable HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        Constraint.isNotNull((Object)request, (String)"HTTP request");
        Constraint.isNotNull(responseHandler, (String)"HTTP response handler");
        HttpHost target = AbstractHttpClient.determineTarget(request);
        return this.execute(target, request, context, responseHandler);
    }

    public <T> T execute(@Nullable HttpHost target, @Nullable ClassicHttpRequest request, @Nullable HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        Constraint.isNotNull((Object)request, (String)"HTTP request");
        Constraint.isNotNull(responseHandler, (String)"HTTP response handler");
        return this.execute(target, request, null, responseHandler);
    }

    public <T> T execute(@Nullable HttpHost target, @Nullable ClassicHttpRequest request, @Nullable HttpContext context, @Nullable HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        HttpClientResponseHandler checkedHandler = (HttpClientResponseHandler)Constraint.isNotNull(responseHandler, (String)"HTTP response handler");
        ClassicHttpResponse response = this.doExecute(target, (ClassicHttpRequest)Constraint.isNotNull((Object)request, (String)"HTTP request"), context);
        try {
            Object result = checkedHandler.handleResponse(response);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            Object object = result;
            return (T)object;
        }
        catch (HttpException t) {
            HttpEntity entity = response.getEntity();
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception t2) {
                LOG.warn("Error consuming content after an exception.", (Throwable)t2);
            }
            throw new ClientProtocolException((Throwable)t);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

