/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.List;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchesTTestUDF;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchesTTestUDFTest {
    @Test
    public void nullSketches() {
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void nullSketchA() {
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(null, new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void nullSketchB() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketchA() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{1.0});
        sketchB.update(2L, new double[]{1.0});
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketchB() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{1.0});
        sketchA.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void oneEntrySketchA() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{1.0});
        sketchB.update(2L, new double[]{1.0});
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void oneEntrySketchB() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{1.0});
        sketchA.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{1.0});
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNull((Object)result);
    }

    @Test
    public void twoEntriesInBothSketchesNoDifference() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{0.99});
        sketchA.update(2L, new double[]{1.01});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{0.99});
        sketchB.update(2L, new double[]{1.01});
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0, (double)0.01);
    }

    @Test
    public void twoEntriesInBothSketchesLargeDifference() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{0.99});
        sketchA.update(2L, new double[]{1.01});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{1.99});
        sketchB.update(2L, new double[]{2.01});
        List result = new ArrayOfDoublesSketchesTTestUDF().evaluate(new BytesWritable(sketchA.compact().toByteArray()), new BytesWritable(sketchB.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0, (double)0.01);
    }
}

