/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesState;
import org.apache.datasketches.hive.tuple.DataToArrayOfDoublesSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToArrayOfDoublesSketchUDAFTest {
    private static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    private static final ObjectInspector doubleInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    private static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    private static final ObjectInspector floatInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
    private static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    private static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "numValues", "sketch"), Arrays.asList(intInspector, intInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooFewArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidCategoryArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidTypeArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryNominalNumEntriesArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeNominalNumEntriesArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryNumNominalEntriesArg4() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, doubleInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeNumNominalEntriesArg4() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, doubleInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategorySamplingProbability() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeSamplingProbability() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void extraParameter() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, floatInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1), new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2), new DoubleWritable(1.0)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)1);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertFalse((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeStringKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector, doubleInspector, doubleInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("a"), new DoubleWritable(1.0), new DoubleWritable(2.0), new IntWritable(32), new FloatWritable(0.99f)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("b"), new DoubleWritable(1.0), new DoubleWritable(2.0), new IntWritable(32), new FloatWritable(0.99f)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)32);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)2);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch1.compact().toByteArray())));
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)1);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch1.compact().toByteArray())));
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1), new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2), new DoubleWritable(1.0)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeDoubleKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, doubleInspector, doubleInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new DoubleWritable(1.0), new DoubleWritable(2.0), new IntWritable(32), new FloatWritable(0.99f)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new DoubleWritable(1.0), new DoubleWritable(2.0), new IntWritable(32), new FloatWritable(0.99f)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeCheckTrimmingToNominal() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            for (int i = 0; i < 10000; ++i) {
                eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(i), new DoubleWritable(1.0)});
            }
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)10000.0, (double)300.0);
            Assert.assertTrue((resultSketch.getRetainedEntries() <= 4096 ? 1 : 0) != 0, (String)("retained entries: " + resultSketch.getRetainedEntries()));
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)3);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector3 = ((StructField)fields.get(2)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector3.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector3 = (PrimitiveObjectInspector)inspector3;
        Assert.assertEquals((Object)primitiveInspector3.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    static void checkFinalResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

