/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.hll.SketchEvaluator;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="unionSketch", value="_FUNC_(firstSketch, secondSketch[, lgK[, type]]) - Compute the union of the given sketches with the given size and seed", extended="The return value is a binary blob that can be operated on by other sketch related functions. The lgK parameter controls the sketch size and relative error expected from the sketch. It is optional and must be from 4 to 21. The default is 12, which is expected to yield errors of roughly +-3% in the estimation of uniques with 95% confidence. The target type parameter is optional and must be 'HLL_4', 'HLL_6' or 'HLL_8'. The default is 'HLL_4'")
public class UnionSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK, String type) {
        TgtHllType hllType = TgtHllType.valueOf((String)type);
        Union union = new Union(lgK);
        if (firstSketch != null) {
            union.update(HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketch)));
        }
        if (secondSketch != null) {
            union.update(HllSketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketch)));
        }
        return new BytesWritable(union.getResult(hllType).toCompactByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK) {
        return this.evaluate(firstSketch, secondSketch, lgK, SketchEvaluator.DEFAULT_HLL_TYPE.toString());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch) {
        return this.evaluate(firstSketch, secondSketch, 12, SketchEvaluator.DEFAULT_HLL_TYPE.toString());
    }
}

