/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.testng.annotations.Test;

public class KllMemoryValidateTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFamily() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentFamilyID((MemorySegment)wseg, (int)(Family.KLL.getID() - 1));
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentSerVer((MemorySegment)wseg, (int)0);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidEmptyAndSingleFormat() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentEmptyFlag((MemorySegment)wseg, (boolean)true);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidUpdatableAndSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentSerVer((MemorySegment)wseg, (int)2);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)5);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleAndSerVer() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentSerVer((MemorySegment)wseg, (int)1);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidEmptyDoublesAndPreIntsFull() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)5);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidSingleDoubleCompactAndSerVer() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentSerVer((MemorySegment)wseg, (int)1);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidDoubleUpdatableAndPreInts() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)2);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_DOUBLES_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFloatFullAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)2);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidFloatUpdatableFullAndPreInts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)2);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidDoubleCompactSingleAndPreInts() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        byte[] byteArr = sk.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        KllPreambleUtil.setMemorySegmentPreInts((MemorySegment)wseg, (int)5);
        new KllMemorySegmentValidate(wseg, KllSketch.SketchType.KLL_DOUBLES_SKETCH);
    }
}

