/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.partitions;

import java.util.List;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.partitions.BoundsRule;
import org.apache.datasketches.partitions.ItemsSketchFillRequestLongAsString;
import org.apache.datasketches.partitions.PartitionResults;
import org.apache.datasketches.partitions.Partitioner;
import org.apache.datasketches.partitions.SketchFillRequest;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public class ClassicPartitionsTest {
    public void main(String[] args) {
        int maxPartsPerSk;
        long tgtPartitionSize;
        long totalN;
        QuantileSearchCriteria searchCrit;
        int k;
        try {
            k = Integer.parseInt(args[0].trim());
            searchCrit = args[1].trim().equalsIgnoreCase("INCLUSIVE") ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE;
            totalN = Long.parseLong(args[2].trim());
            tgtPartitionSize = Long.parseLong(args[3].trim());
            maxPartsPerSk = Integer.parseInt(args[4].trim());
        }
        catch (NumberFormatException e) {
            throw new SketchesArgumentException(e.toString());
        }
        this.classicPartitioner(k, searchCrit, totalN, tgtPartitionSize, maxPartsPerSk);
    }

    public void checkClassicPartitioner() {
        int k = 32768;
        QuantileSearchCriteria searchCrit = QuantileSearchCriteria.INCLUSIVE;
        long totalN = 30000000L;
        long tgtPartitionSize = 3000000L;
        int maxPartsPerSk = 100;
        this.classicPartitioner(32768, searchCrit, 30000000L, 3000000L, 100);
    }

    public void classicPartitioner(int k, QuantileSearchCriteria searchCrit, long totalN, long tgtPartitionSize, int maxPartsPerSk) {
        long startTime_mS = System.currentTimeMillis();
        ItemsSketchFillRequestLongAsString fillReq = new ItemsSketchFillRequestLongAsString(k, totalN);
        QuantilesItemsSketch<String> sk = fillReq.getRange(1L, totalN, BoundsRule.INCLUDE_BOTH);
        long endFillInitialSketchTime_mS = System.currentTimeMillis();
        Partitioner partitioner = new Partitioner(tgtPartitionSize, maxPartsPerSk, (SketchFillRequest)fillReq, searchCrit);
        List list = partitioner.partition(sk);
        long endTime_mS = System.currentTimeMillis();
        long fillInitialSketchTime_mS = endFillInitialSketchTime_mS - startTime_mS;
        long partitioningTime_mS = endTime_mS - endFillInitialSketchTime_mS;
        long totalTime_mS = endTime_mS - startTime_mS;
        PartitionResults.output("Classic", list, k, searchCrit, totalN, tgtPartitionSize, maxPartsPerSk, fillInitialSketchTime_mS, partitioningTime_mS, totalTime_mS);
    }
}

