/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesMiscTest {
    @Test
    public void wrapAndUpdating() {
        UpdatableQuantilesDoublesSketch sk1 = QuantilesDoublesSketch.builder().build();
        sk1.update(1.0);
        sk1.update(2.0);
        byte[] bytes = sk1.toByteArray(false);
        int curBytes = sk1.getCurrentUpdatableSerializedSizeBytes();
        Assert.assertEquals((int)bytes.length, (int)curBytes);
        MemorySegment seg = MemorySegment.ofArray(bytes);
        UpdatableQuantilesDoublesSketch sk2 = (UpdatableQuantilesDoublesSketch)QuantilesDoublesSketch.writableWrap((MemorySegment)seg, null);
        Assert.assertEquals((long)seg.byteSize(), (long)curBytes);
        sk2.update(3.0);
        sk2.update(4.0);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)4.0);
        MemorySegment seg2 = sk2.getMemorySegment();
        Assert.assertEquals((long)seg2.byteSize(), (long)QuantilesDoublesSketch.getUpdatableStorageBytes((int)sk2.getK(), (long)sk2.getN()));
    }

    @Test
    public void wrapCompactSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.compact().toByteArray());
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)2.0);
        Assert.assertEquals((long)s2.getN(), (long)2L);
    }

    @Test
    public void heapifySparseSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(false));
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)2.0);
    }

    @Test
    public void heapifyAndUpdateSparseSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(false));
        UpdatableQuantilesDoublesSketch s2 = (UpdatableQuantilesDoublesSketch)QuantilesDoublesSketch.heapify((MemorySegment)seg);
        s2.update(3.0);
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)3.0);
    }

    @Test
    public void heapifyCompactSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(true));
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)2.0);
    }

    @Test
    public void heapifyEmptyUpdateSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray());
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void heapifyEmptyCompactSketch() {
        CompactQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build().compact();
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray());
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void wrapEmptyUpdateSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray()).asReadOnly();
        UpdatableQuantilesDoublesSketch s2 = (UpdatableQuantilesDoublesSketch)QuantilesDoublesSketch.writableWrap((MemorySegment)seg, null);
        Assert.assertTrue((boolean)s2.isEmpty());
        try {
            s2.putMinItem(-1.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putMaxItem(1.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putN(1L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putBitPattern(1L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putBaseBufferCount(5);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putCombinedBuffer(new double[16]);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            int currCap = s2.getCombinedBufferItemCapacity();
            s2.growCombinedBuffer(currCap, 2 * currCap);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void wrapEmptyCompactSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        MemorySegment seg = MemorySegment.ofArray(s1.compact().toByteArray());
        QuantilesDoublesSketch s2 = QuantilesDoublesSketch.wrap((MemorySegment)seg);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void heapifyUnionFromSparse() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(false));
        QuantilesDoublesUnion u = QuantilesDoublesUnion.heapify((MemorySegment)seg);
        u.update(3.0);
        UpdatableQuantilesDoublesSketch s2 = u.getResult();
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)3.0);
    }

    @Test
    public void initializeUnionFromCompactSegment() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(true));
        QuantilesDoublesUnion u = QuantilesDoublesUnion.heapify((MemorySegment)seg);
        u.update(3.0);
        UpdatableQuantilesDoublesSketch s2 = u.getResult();
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)3.0);
    }

    @Test
    public void unionFromUpdatableSegment() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(false));
        QuantilesDoublesUnion u = QuantilesDoublesUnion.wrap((MemorySegment)seg);
        u.update(3.0);
        UpdatableQuantilesDoublesSketch s2 = u.getResult();
        Assert.assertEquals((double)s2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)s2.getMaxItem(), (double)3.0);
    }

    @Test
    public void wrapUnionFromHeap() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(false)).asReadOnly();
        try {
            QuantilesDoublesUnion quantilesDoublesUnion = QuantilesDoublesUnion.wrap((MemorySegment)seg, null);
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrapUnionFromCompact() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        MemorySegment seg = MemorySegment.ofArray(s1.toByteArray(true));
        QuantilesDoublesUnion.wrap((MemorySegment)seg, null);
        Assert.fail();
    }

    private static void println(Object o) {
    }
}

