/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketchBuilder;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HeapUpdateDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        QuantilesDoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void checkEndToEnd() {
        int k = 256;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(256).build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().setK(256).build();
        int n = 1000000;
        for (int item = 1000000; item >= 1; --item) {
            if (item % 4 == 0) {
                qs.update((double)item);
                continue;
            }
            qs2.update((double)item);
        }
        Assert.assertEquals((long)(qs.getN() + qs2.getN()), (long)1000000L);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs);
        union.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        int numPhiValues = 99;
        double[] phiArr = new double[99];
        for (int q = 1; q <= 99; ++q) {
            phiArr[q - 1] = (double)q / 100.0;
        }
        double[] splitPoints = result.getQuantiles(phiArr);
        for (int q = 1; q <= 99; ++q) {
            double reported = splitPoints[q - 1];
            double nominal = 1000000.0 * (double)q / 100.0;
            Assert.assertTrue((reported >= nominal - 10000.0 ? 1 : 0) != 0);
            Assert.assertTrue((reported <= nominal + 10000.0 ? 1 : 0) != 0);
        }
        double[] pmfResult = result.getPMF(splitPoints);
        double subtotal = 0.0;
        for (int q = 1; q <= 100; ++q) {
            double phi = (double)q / 100.0;
            Assert.assertTrue(((subtotal += pmfResult[q - 1]) >= phi - 0.01 ? 1 : 0) != 0);
            Assert.assertTrue((subtotal <= phi + 0.01 ? 1 : 0) != 0);
        }
        double[] cdfResult = result.getCDF(splitPoints);
        for (int q = 1; q <= 100; ++q) {
            subtotal = cdfResult[q - 1];
            double phi = (double)q / 100.0;
            Assert.assertTrue((subtotal >= phi - 0.01 ? 1 : 0) != 0);
            Assert.assertTrue((subtotal <= phi + 0.01 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)result.getRank(500000.0), (double)0.5, (double)0.01);
    }

    @Test
    public void checkSmallMinMax() {
        int k = 32;
        int n = 8;
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(32).build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().setK(32).build();
        UpdatableQuantilesDoublesSketch qs3 = QuantilesDoublesSketch.builder().setK(32).build();
        for (int i = 8; i >= 1; --i) {
            qs1.update((double)i);
            qs2.update((double)(10 + i));
            qs3.update((double)i);
        }
        Assert.assertEquals((double)qs1.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs1.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs1.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)qs2.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)11.0);
        Assert.assertEquals((double)qs2.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)15.0);
        Assert.assertEquals((double)qs2.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)18.0);
        Assert.assertEquals((double)qs3.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs3.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs3.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        double[] queries = new double[]{0.0, 0.5, 1.0};
        double[] resultsA = qs1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsA[0], (double)1.0);
        Assert.assertEquals((double)resultsA[1], (double)5.0);
        Assert.assertEquals((double)resultsA[2], (double)8.0);
        QuantilesDoublesUnion union1 = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs1);
        union1.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch result1 = union1.getResult();
        QuantilesDoublesUnion union2 = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        union2.union((QuantilesDoublesSketch)qs3);
        UpdatableQuantilesDoublesSketch result2 = union2.getResult();
        double[] resultsB = result1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsB[0], (double)1.0);
        Assert.assertEquals((double)resultsB[1], (double)11.0);
        Assert.assertEquals((double)resultsB[2], (double)18.0);
        double[] resultsC = result2.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsC[0], (double)1.0);
        Assert.assertEquals((double)resultsC[1], (double)11.0);
        Assert.assertEquals((double)resultsC[2], (double)18.0);
    }

    @Test
    public void checkMisc() {
        int k = 128;
        int n = 10000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 10000);
        qs.update(Double.NaN);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)10000);
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
    }

    @Test
    public void checkToStringDetail() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0);
        String s = qs.toString();
        s = qs.toString(false, true);
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000000);
        s = qs.toString();
        s = qs.toString(false, true);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)1000000);
        qs.update(Double.NaN);
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorException() {
        QuantilesDoublesSketch.builder().setK(0).build();
    }

    @Test
    public void checkPreLongsFlagsAndSize() {
        UpdatableQuantilesDoublesSketch ds = QuantilesDoublesSketch.builder().build();
        byte[] byteArr = ds.toByteArray(true);
        Assert.assertEquals((int)byteArr.length, (int)8);
        byteArr = ds.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)8);
        Assert.assertEquals((int)byteArr[3], (int)4);
        ds.update(1.0);
        byteArr = ds.toByteArray(true);
        Assert.assertEquals((int)byteArr.length, (int)40);
        byteArr = ds.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)64);
    }

    @Test
    public void checkPreLongsFlagsSerVerB() {
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)1, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)1, (int)5);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)2, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)2, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)12, (int)3, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)12, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)8, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)3, (int)2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsSerVer3() {
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)1, (int)2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetQuantiles() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000000);
        double[] frac = new double[]{-0.5};
        qs.getQuantiles(frac);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetQuantile() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000000);
        double frac = -0.5;
        qs.getQuantile(-0.5);
    }

    public void summaryCheckViaMemory() {
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000000);
        String s = qs.toString();
        HeapUpdateDoublesSketchTest.println(s);
        HeapUpdateDoublesSketchTest.println("");
        MemorySegment srcSeg = MemorySegment.ofArray(qs.toByteArray());
        HeapUpdateDoublesSketch qs2 = HeapUpdateDoublesSketch.heapifyInstance((MemorySegment)srcSeg);
        s = qs2.toString();
        HeapUpdateDoublesSketchTest.println(s);
    }

    @Test
    public void checkComputeNumLevelsNeeded() {
        int n = 0x100000;
        int k = 128;
        int lvls1 = ClassicUtil.computeNumLevelsNeeded((int)128, (long)0x100000L);
        int lvls2 = (int)Math.max(Math.floor(Util.log2((double)8192.0)), 0.0);
        Assert.assertEquals((int)lvls1, (int)lvls2);
    }

    @Test
    public void checkComputeBitPattern() {
        int n = 0x100000;
        int k = 128;
        long bitP = ClassicUtil.computeBitPattern((int)128, (long)0x100000L);
        Assert.assertEquals((long)bitP, (long)4096L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkValidateSplitPointsOrder() {
        double[] arr = new double[]{2.0, 1.0};
        QuantilesUtil.checkDoublesSplitPointsOrder((double[])arr);
    }

    @Test
    public void checkGetStorageBytes() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0);
        int stor = qs.getCurrentCompactSerializedSizeBytes();
        Assert.assertEquals((int)stor, (int)8);
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 256);
        stor = qs.getCurrentCompactSerializedSizeBytes();
        int retItems = ClassicUtil.computeRetainedItems((int)128, (long)256L);
        Assert.assertEquals((int)stor, (int)(32 + (retItems << 3)));
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 255);
        stor = qs.getCurrentCompactSerializedSizeBytes();
        retItems = ClassicUtil.computeRetainedItems((int)128, (long)255L);
        Assert.assertEquals((int)stor, (int)(32 + (retItems << 3)));
    }

    @Test
    public void checkGetStorageBytes2() {
        int k = 128;
        long v = 1L;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(128).build();
        for (int i = 0; i < 1000; ++i) {
            qs.update((double)v++);
            byte[] byteArr = qs.toByteArray(false);
            Assert.assertEquals((int)byteArr.length, (int)qs.getCurrentUpdatableSerializedSizeBytes());
        }
    }

    @Test
    public void checkMerge() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000000, 0);
        UpdatableQuantilesDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0, 0);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        union.union((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        double med1 = qs1.getQuantile(0.5);
        double med2 = result.getQuantile(0.5);
        Assert.assertEquals((double)med1, (double)med2, (double)0.0);
    }

    @Test
    public void checkReverseMerge() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000, 0);
        UpdatableQuantilesDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000, 1000);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        union.union((QuantilesDoublesSketch)qs1);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkInternalBuildHistogram() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000000, 0);
        double eps = qs.getNormalizedRankError(true);
        double[] spts = new double[]{100000.0, 500000.0, 900000.0};
        double[] fracArr = qs.getPMF(spts);
        Assert.assertEquals((double)fracArr[0], (double)0.1, (double)eps);
        Assert.assertEquals((double)fracArr[1], (double)0.4, (double)eps);
        Assert.assertEquals((double)fracArr[2], (double)0.4, (double)eps);
        Assert.assertEquals((double)fracArr[3], (double)0.1, (double)eps);
    }

    @Test
    public void checkComputeBaseBufferCount() {
        int n = 0x100000;
        int k = 128;
        long bbCnt = ClassicUtil.computeBaseBufferItems((int)128, (long)0x100000L);
        Assert.assertEquals((long)bbCnt, (long)0L);
    }

    @Test
    public void checkToFromByteArray() {
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(128, 1300);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 7);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 8);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 9);
    }

    private static void checkToFromByteArray2(int k, int n) {
        double f;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        byte[] byteArr = qs.toByteArray(true);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        UpdatableQuantilesDoublesSketch qs2 = UpdatableQuantilesDoublesSketch.heapify((MemorySegment)seg);
        for (double f2 = 0.1; f2 < 0.95; f2 += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f2), (double)qs2.getQuantile(f2), (double)0.0);
        }
        byteArr = qs.toByteArray(false);
        seg = MemorySegment.ofArray(byteArr);
        qs2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap((QuantilesDoublesSketch)qs2, (boolean)false);
        dsa.sort();
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f), (double)qs2.getQuantile(f), (double)0.0);
        }
        byteArr = qs.toByteArray(false);
        seg = MemorySegment.ofArray(byteArr);
        qs2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f), (double)qs2.getQuantile(f), (double)0.0);
        }
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0);
        byte[] byteArr = qs1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        QuantilesDoublesSketch qs2 = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        Assert.assertTrue((boolean)qs2.isEmpty());
        int expectedSizeBytes = 8;
        Assert.assertEquals((int)byteArr.length, (int)8);
        try {
            qs2.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getQuantiles(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getRank(0.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegTooSmall1() {
        MemorySegment seg = MemorySegment.ofArray(new byte[7]);
        HeapUpdateDoublesSketch.heapifyInstance((MemorySegment)seg);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSerVer() {
        DoublesUtil.checkDoublesSerVer((int)0, (int)1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFamilyID() {
        ClassicUtil.checkFamilyID((int)3);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSegCapacityException() {
        int k = 128;
        long n = 1000L;
        int serVer = 3;
        int combBufItemCap = ClassicUtil.computeCombinedBufferItemCapacity((int)128, (long)1000L);
        int segCapBytes = combBufItemCap + 4 << 3;
        int badCapBytes = segCapBytes - 1;
        HeapUpdateDoublesSketch.checkHeapSegCapacity((int)128, (long)1000L, (boolean)false, (int)3, (long)badCapBytes);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBufAllocAndCap() {
        int k = 128;
        long n = 1000L;
        int serVer = 3;
        int combBufItemCap = ClassicUtil.computeCombinedBufferItemCapacity((int)128, (long)1000L);
        int segCapBytes = combBufItemCap + 4 << 3;
        int segCapBytesV1 = combBufItemCap + 5 << 3;
        HeapUpdateDoublesSketch.checkHeapSegCapacity((int)128, (long)1000L, (boolean)false, (int)1, (long)segCapBytesV1);
        HeapUpdateDoublesSketch.checkHeapSegCapacity((int)128, (long)1000L, (boolean)false, (int)3, (long)(segCapBytes - 1));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsCap() {
        int preLongs = 5;
        int flags = 4;
        int segCap = 8;
        ClassicUtil.checkPreLongsFlagsCap((int)5, (int)4, (long)8L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsCap2() {
        int preLongs = 5;
        boolean flags = false;
        int segCap = 8;
        ClassicUtil.checkPreLongsFlagsCap((int)5, (int)0, (long)8L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFlags() {
        boolean flags = true;
        ClassicUtil.checkHeapFlags((int)1);
    }

    @Test
    public void checkZeroPatternReturn() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 64);
        byte[] byteArr = qs1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        HeapUpdateDoublesSketch.heapifyInstance((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadDownSamplingRatio() {
        int k1 = 64;
        UpdatableQuantilesDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(64, 64);
        qs1.downSample((QuantilesDoublesSketch)qs1, 128, null, null);
    }

    @Test
    public void checkImproperKvalues() {
        HeapUpdateDoublesSketchTest.checksForImproperK(0);
        HeapUpdateDoublesSketchTest.checksForImproperK(65536);
    }

    static void testDownSampling(int bigK, int smallK) {
        HeapUpdateDoublesSketch sketch1 = HeapUpdateDoublesSketch.newInstance((int)bigK);
        HeapUpdateDoublesSketch sketch2 = HeapUpdateDoublesSketch.newInstance((int)smallK);
        for (int i = 127; i >= 1; --i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
        }
        HeapUpdateDoublesSketch downSketch = (HeapUpdateDoublesSketch)sketch1.downSample((QuantilesDoublesSketch)sketch1, smallK, null, null);
        HeapUpdateDoublesSketchTest.println(Util.LS + "Sk1" + Util.LS);
        String s1 = sketch1.toString(true, true);
        HeapUpdateDoublesSketchTest.println(s1);
        HeapUpdateDoublesSketchTest.println(Util.LS + "Down" + Util.LS);
        String down = downSketch.toString(true, true);
        HeapUpdateDoublesSketchTest.println(down);
        HeapUpdateDoublesSketchTest.println(Util.LS + "Sk2" + Util.LS);
        String s2 = sketch2.toString(true, true);
        HeapUpdateDoublesSketchTest.println(s2);
        Assert.assertEquals((int)downSketch.getNumRetained(), (int)sketch2.getNumRetained());
    }

    @Test
    public void checkDownSampling() {
        HeapUpdateDoublesSketchTest.testDownSampling(4, 4);
        HeapUpdateDoublesSketchTest.testDownSampling(16, 4);
    }

    @Test
    public void testDownSampling2() {
        HeapUpdateDoublesSketch sketch1 = HeapUpdateDoublesSketch.newInstance((int)8);
        HeapUpdateDoublesSketch sketch2 = HeapUpdateDoublesSketch.newInstance((int)2);
        QuantilesDoublesSketch downSketch = sketch1.downSample((QuantilesDoublesSketch)sketch1, 2, null, null);
        Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((QuantilesDoublesSketch)sketch2, downSketch));
        for (int i = 0; i < 50; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            downSketch = sketch1.downSample((QuantilesDoublesSketch)sketch1, 2, null, null);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((QuantilesDoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling3() {
        int k1 = 8;
        int k2 = 2;
        int n = 50;
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().setK(8).build();
        UpdatableQuantilesDoublesSketch sketch2 = QuantilesDoublesSketch.builder().setK(2).build();
        for (int i = 0; i < 50; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            QuantilesDoublesSketch downSketch = sketch1.downSample((QuantilesDoublesSketch)sketch1, 2, null, null);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((QuantilesDoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling3withSeg() {
        int k1 = 8;
        int k2 = 2;
        int n = 50;
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().setK(8).build();
        UpdatableQuantilesDoublesSketch sketch2 = QuantilesDoublesSketch.builder().setK(2).build();
        int bytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)2, (long)50L);
        MemorySegment seg = MemorySegment.ofArray(new byte[bytes]);
        for (int i = 0; i < 50; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            QuantilesDoublesSketch downSketch = sketch1.downSample((QuantilesDoublesSketch)sketch1, 2, seg, null);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((QuantilesDoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling4() {
        for (int n1 = 0; n1 < 50; ++n1) {
            HeapUpdateDoublesSketch bigSketch = HeapUpdateDoublesSketch.newInstance((int)8);
            for (int i1 = 1; i1 <= n1; ++i1) {
                bigSketch.update((double)i1);
            }
            for (int n2 = 0; n2 < 50; ++n2) {
                HeapUpdateDoublesSketch directSketch = HeapUpdateDoublesSketch.newInstance((int)2);
                for (int i1 = 1; i1 <= n1; ++i1) {
                    directSketch.update((double)i1);
                }
                for (int i2 = 1; i2 <= n2; ++i2) {
                    directSketch.update((double)i2);
                }
                HeapUpdateDoublesSketch smlSketch = HeapUpdateDoublesSketch.newInstance((int)2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    smlSketch.update((double)i2);
                }
                DoublesMergeImpl.downSamplingMergeInto((QuantilesDoublesSketch)bigSketch, (UpdatableQuantilesDoublesSketch)smlSketch);
                Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((QuantilesDoublesSketch)directSketch, (QuantilesDoublesSketch)smlSketch));
            }
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions1() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(4).build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().setK(3).build();
        DoublesMergeImpl.mergeInto((QuantilesDoublesSketch)qs2, (UpdatableQuantilesDoublesSketch)qs1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions2() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(4).build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().setK(7).build();
        DoublesMergeImpl.mergeInto((QuantilesDoublesSketch)qs2, (UpdatableQuantilesDoublesSketch)qs1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions3() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(4).build();
        UpdatableQuantilesDoublesSketch qs2 = QuantilesDoublesSketch.builder().setK(12).build();
        DoublesMergeImpl.mergeInto((QuantilesDoublesSketch)qs2, (UpdatableQuantilesDoublesSketch)qs1);
    }

    public void quantilesCheckViaMemory() {
        int k = 256;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000000);
        double[] ranks = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        String s = HeapUpdateDoublesSketchTest.getRanksTable((QuantilesDoublesSketch)qs, ranks);
        HeapUpdateDoublesSketchTest.println(s);
        HeapUpdateDoublesSketchTest.println("");
        MemorySegment srcSeg = MemorySegment.ofArray(qs.toByteArray());
        HeapUpdateDoublesSketch qs2 = HeapUpdateDoublesSketch.heapifyInstance((MemorySegment)srcSeg);
        HeapUpdateDoublesSketchTest.println(HeapUpdateDoublesSketchTest.getRanksTable((QuantilesDoublesSketch)qs2, ranks));
    }

    static String getRanksTable(QuantilesDoublesSketch qs, double[] ranks) {
        double rankError = qs.getNormalizedRankError(false);
        double[] values = qs.getQuantiles(ranks);
        double maxV = qs.getMaxItem();
        double minV = qs.getMinItem();
        double delta = maxV - minV;
        HeapUpdateDoublesSketchTest.println("Note: This prints the relative value errors for illustration.");
        HeapUpdateDoublesSketchTest.println("The quantiles sketch does not and can not guarantee relative value errors");
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("N = ").append(qs.getN()).append(Util.LS);
        sb.append("K = ").append(qs.getK()).append(Util.LS);
        String formatStr1 = "%10s%15s%10s%15s%10s%10s";
        String formatStr2 = "%10.1f%15.5f%10.0f%15.5f%10.5f%10.5f";
        String hdr = String.format("%10s%15s%10s%15s%10s%10s", "Rank", "ValueLB", "<= Value", "<= ValueUB", "RelErrLB", "RelErrUB");
        sb.append(hdr).append(Util.LS);
        for (int i = 0; i < ranks.length; ++i) {
            double rank = ranks[i];
            double value = values[i];
            if (rank == 0.0) {
                Assert.assertEquals((double)value, (double)minV, (double)0.0);
                continue;
            }
            if (rank == 1.0) {
                Assert.assertEquals((double)value, (double)maxV, (double)0.0);
                continue;
            }
            double rankUB = rank + rankError;
            double valueUB = minV + delta * rankUB;
            double rankLB = Math.max(rank - rankError, 0.0);
            double valueLB = minV + delta * rankLB;
            Assert.assertTrue((value < valueUB ? 1 : 0) != 0);
            Assert.assertTrue((value > valueLB ? 1 : 0) != 0);
            double valRelPctErrUB = valueUB / value - 1.0;
            double valRelPctErrLB = valueLB / value - 1.0;
            String row = String.format("%10.1f%15.5f%10.0f%15.5f%10.5f%10.5f", rank, valueLB, value, valueUB, valRelPctErrLB, valRelPctErrUB);
            sb.append(row).append(Util.LS);
        }
        return sb.toString();
    }

    @Test
    public void checkKisTwo() {
        int k = 2;
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(2).build();
        double err = qs1.getNormalizedRankError(false);
        Assert.assertTrue((err < 1.0 ? 1 : 0) != 0);
        byte[] arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)QuantilesDoublesSketch.getCompactSerialiedSizeBytes((int)2, (long)0L));
        qs1.update(1.0);
        arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)QuantilesDoublesSketch.getCompactSerialiedSizeBytes((int)2, (long)1L));
    }

    @Test
    public void checkKisTwoDeprecated() {
        int k = 2;
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().setK(2).build();
        double err = qs1.getNormalizedRankError(false);
        Assert.assertTrue((err < 1.0 ? 1 : 0) != 0);
        byte[] arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)QuantilesDoublesSketch.getCompactSerialiedSizeBytes((int)2, (long)0L));
        Assert.assertEquals((int)arr.length, (int)qs1.getCurrentCompactSerializedSizeBytes());
        qs1.update(1.0);
        arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)QuantilesDoublesSketch.getCompactSerialiedSizeBytes((int)2, (long)1L));
        Assert.assertEquals((int)arr.length, (int)qs1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void checkPutMemory() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentUpdatableSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes]);
        qs1.putIntoMemorySegment(dstSeg, false);
        MemorySegment srcSeg = dstSeg;
        QuantilesDoublesSketch qs2 = QuantilesDoublesSketch.heapify((MemorySegment)srcSeg);
        Assert.assertEquals((double)qs1.getMinItem(), (double)qs2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)qs1.getMaxItem(), (double)qs2.getMaxItem(), (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPutMemoryTooSmall() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes - 1]);
        qs1.putIntoMemorySegment(dstSeg);
    }

    @Test
    public void testIt() {
        ByteBuffer bb = ByteBuffer.allocate(0x100000).order(ByteOrder.nativeOrder());
        MemorySegment seg = MemorySegment.ofBuffer(bb);
        int k = 1024;
        UpdatableQuantilesDoublesSketch qsk = new QuantilesDoublesSketchBuilder().setK(1024).build();
        QuantilesDoublesUnion u1 = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qsk);
        u1.getResult().putIntoMemorySegment(seg);
        QuantilesDoublesUnion u2 = QuantilesDoublesUnion.heapify((MemorySegment)seg);
        UpdatableQuantilesDoublesSketch qsk2 = u2.getResult();
        Assert.assertTrue((boolean)qsk2.isEmpty());
    }

    @Test
    public void checkEquallySpacedRanks() {
        int n = 10;
        double[] es = QuantilesUtil.equallySpacedDoubles((int)10);
        int len = es.length;
        for (int j = 0; j < len; ++j) {
            double f = es[j];
            Assert.assertEquals((double)f, (double)((double)j / 10.0), (double)((double)j / 10.0 * 0.001));
            HeapUpdateDoublesSketchTest.print(es[j] + ", ");
        }
        HeapUpdateDoublesSketchTest.println("");
    }

    @Test
    public void checkPMFonEmpty() {
        UpdatableQuantilesDoublesSketch qsk = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 1001);
        double[] array = new double[]{};
        double[] qOut = qsk.getQuantiles(array);
        Assert.assertEquals((int)qOut.length, (int)0);
        HeapUpdateDoublesSketchTest.println("qOut: " + qOut.length);
        double[] cdfOut = qsk.getCDF(array);
        HeapUpdateDoublesSketchTest.println("cdfOut: " + cdfOut.length);
        Assert.assertEquals((double)cdfOut[0], (double)1.0, (double)0.0);
    }

    @Test
    public void checkPuts() {
        long n1 = 1001L;
        UpdatableQuantilesDoublesSketch qsk = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 1001);
        long n2 = qsk.getN();
        Assert.assertEquals((long)n2, (long)1001L);
        int bbCnt1 = qsk.getBaseBufferCount();
        long pat1 = qsk.getBitPattern();
        qsk.putBitPattern(pat1 + 1L);
        long pat2 = qsk.getBitPattern();
        Assert.assertEquals((long)(pat1 + 1L), (long)pat2);
        qsk.putBaseBufferCount(bbCnt1 + 1);
        int bbCnt2 = qsk.getBaseBufferCount();
        Assert.assertEquals((int)(bbCnt1 + 1), (int)bbCnt2);
        qsk.putN(1002L);
        long n3 = qsk.getN();
        Assert.assertEquals((long)1002L, (long)n3);
        Assert.assertNull((Object)qsk.getMemorySegment());
    }

    @Test
    public void serializeDeserializeCompact() {
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        UpdatableQuantilesDoublesSketch sketch2 = (UpdatableQuantilesDoublesSketch)QuantilesDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(sketch1.toByteArray()));
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)(i + 1000));
        }
        Assert.assertEquals((double)sketch2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void serializeDeserializeEmptyNonCompact() {
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().build();
        byte[] byteArr = sketch1.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)sketch1.getSerializedSizeBytes());
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        UpdatableQuantilesDoublesSketch sketch2 = (UpdatableQuantilesDoublesSketch)QuantilesDoublesSketch.heapify((MemorySegment)seg);
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)i);
        }
        Assert.assertEquals((double)sketch2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)500.0, (double)4.0);
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int i;
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        int n = 1000000;
        double[] values = new double[1000000];
        for (int i2 = 0; i2 < 1000000; ++i2) {
            sketch.update((double)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void maxK() {
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().setK(32768).build();
        Assert.assertEquals((int)sketch.getK(), (int)32768);
    }

    @Test
    public void checkBounds() {
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        double eps = sketch.getNormalizedRankError(false);
        double est = sketch.getQuantile(0.5);
        double ub = sketch.getQuantileUpperBound(0.5);
        double lb = sketch.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)sketch.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)sketch.getQuantile(0.5 - eps));
        HeapUpdateDoublesSketchTest.println("Ext     : " + est);
        HeapUpdateDoublesSketchTest.println("UB      : " + ub);
        HeapUpdateDoublesSketchTest.println("LB      : " + lb);
    }

    @Test
    public void checkGetKFromEqs() {
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        int k = sketch.getK();
        double eps = QuantilesDoublesSketch.getNormalizedRankError((int)k, (boolean)false);
        double epsPmf = QuantilesDoublesSketch.getNormalizedRankError((int)k, (boolean)true);
        int kEps = QuantilesDoublesSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = QuantilesDoublesSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)k);
        Assert.assertEquals((int)kEpsPmf, (int)k);
    }

    @Test
    public void tenItems() {
        int i;
        int i2;
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        for (i2 = 1; i2 <= 10; ++i2) {
            sketch.update((double)i2);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i2 = 1; i2 <= 10; ++i2) {
            Assert.assertEquals((double)sketch.getRank((double)i2, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i2 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i2, QuantileSearchCriteria.INCLUSIVE), (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE), (double)10.0);
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0), (double)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (double)quantiles[i]);
        }
    }

    private static void checksForImproperK(int k) {
        String s = "Did not catch improper k: " + k;
        try {
            QuantilesDoublesSketch.builder().setK(k);
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            QuantilesDoublesSketch.builder().setK(k).build();
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HeapUpdateDoublesSketch.newInstance((int)k);
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    private static boolean sameStructurePredicate(QuantilesDoublesSketch mq1, QuantilesDoublesSketch mq2) {
        boolean b1;
        boolean bl = b1 = mq1.getK() == mq2.getK() && mq1.getN() == mq2.getN() && mq1.getCombinedBufferItemCapacity() >= ClassicUtil.computeCombinedBufferItemCapacity((int)mq1.getK(), (long)mq1.getN()) && mq2.getCombinedBufferItemCapacity() >= ClassicUtil.computeCombinedBufferItemCapacity((int)mq2.getK(), (long)mq2.getN()) && mq1.getBaseBufferCount() == mq2.getBaseBufferCount() && mq1.getBitPattern() == mq2.getBitPattern();
        boolean b2 = mq1.isEmpty() ? mq2.isEmpty() : mq1.getMinItem() == mq2.getMinItem() && mq1.getMaxItem() == mq2.getMaxItem();
        return b1 && b2;
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadQS(int k, int n) {
        return HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n, 0);
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadQS(int k, int n, int startV) {
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        return qs;
    }

    @Test
    public void printlnTest() {
        HeapUpdateDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        HeapUpdateDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + Util.LS);
    }

    static void println(Object o) {
        HeapUpdateDoublesSketchTest.print(o.toString() + Util.LS);
    }

    static void print(Object o) {
    }
}

