/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerDeCompatibilityTest {
    private static final ArrayOfItemsSerDe<Double> serDe = new ArrayOfDoublesSerDe();

    @Test
    public void itemsToDoubles() {
        QuantilesItemsSketch sketch1 = QuantilesItemsSketch.getInstance(Double.class, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        byte[] bytes = sketch1.toByteArray(serDe);
        UpdatableQuantilesDoublesSketch sketch2 = UpdatableQuantilesDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((double)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1000.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)500.0, (double)17.0);
    }

    @Test
    public void doublesToItems() {
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().build();
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((double)i);
        }
        CompactQuantilesDoublesSketch cs = sketch1.compact();
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)sketch1, (QuantilesDoublesSketch)cs);
        byte[] bytes = cs.toByteArray();
        QuantilesItemsSketch sketch2 = QuantilesItemsSketch.heapify(Double.class, (MemorySegment)MemorySegment.ofArray(bytes), Comparator.naturalOrder(), serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getNumRetained() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((double)((Double)sketch2.getMinItem()), (double)1.0);
        Assert.assertEquals((double)((Double)sketch2.getMaxItem()), (double)1000.0);
        Assert.assertEquals((double)((Double)sketch2.getQuantile(0.5)), (double)500.0, (double)17.0);
    }
}

