/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.testng.annotations.Test;

public class CornerCaseThetaSetOperationsTest {
    private static final long GT_MIDP_V = 3L;
    private static final float MIDP = 0.5f;
    private static final long GT_LOWP_V = 6L;
    private static final float LOWP = 0.1f;
    private static final long LT_LOWP_V = 4L;
    private static final double LOWP_THETA = (double)0.1f;

    @Test
    public void emptyEmpty() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = true;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 0, true);
    }

    @Test
    public void emptyExact() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void emptyDegenerate() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 0, false);
    }

    @Test
    public void emptyEstimation() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 1, false);
    }

    @Test
    public void exactEmpty() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 1, false, 1.0, 1, false);
    }

    @Test
    public void exactExact() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 1, false, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void exactDegenerate() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void exactEstimation() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEmpty() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationExact() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationDegenerate() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEstimation() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateEmpty() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateExact() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateDegenerate() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateEstimation() {
        UpdatableThetaSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    private static void checks(UpdatableThetaSketch thetaA, UpdatableThetaSketch thetaB, double expectedIntersectTheta, int expectedIntersectCount, boolean expectedIntersectEmpty, double expectedAnotbTheta, int expectedAnotbCount, boolean expectedAnotbEmpty, double expectedUnionTheta, int expectedUnionCount, boolean expectedUnionEmpty) {
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        ThetaAnotB anotb = ThetaSetOperation.builder().buildANotB();
        ThetaUnion union = new ThetaSetOperationBuilder().buildUnion();
        CompactThetaSketch csk = inter.intersect((ThetaSketch)thetaA, (ThetaSketch)thetaB);
        CornerCaseThetaSetOperationsTest.checkResult("ThetaIntersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((ThetaSketch)thetaA.compact(), (ThetaSketch)thetaB.compact());
        CornerCaseThetaSetOperationsTest.checkResult("ThetaIntersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = anotb.aNotB((ThetaSketch)thetaA, (ThetaSketch)thetaB);
        CornerCaseThetaSetOperationsTest.checkResult("ThetaAnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = anotb.aNotB((ThetaSketch)thetaA.compact(), (ThetaSketch)thetaB.compact());
        CornerCaseThetaSetOperationsTest.checkResult("ThetaAnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((ThetaSketch)thetaA);
        anotb.notB((ThetaSketch)thetaB);
        csk = anotb.getResult(true);
        CornerCaseThetaSetOperationsTest.checkResult("ThetaAnotB Stateful Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((ThetaSketch)thetaA.compact());
        anotb.notB((ThetaSketch)thetaB.compact());
        csk = anotb.getResult(true);
        CornerCaseThetaSetOperationsTest.checkResult("ThetaAnotB Stateful Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        union.union((ThetaSketch)thetaA);
        union.union((ThetaSketch)thetaB);
        csk = union.getResult();
        union.reset();
        CornerCaseThetaSetOperationsTest.checkResult("ThetaUnion Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((ThetaSketch)thetaA.compact());
        union.union((ThetaSketch)thetaB.compact());
        csk = union.getResult();
        union.reset();
        CornerCaseThetaSetOperationsTest.checkResult("ThetaUnion Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
    }

    private static void checkResult(String comment, CompactThetaSketch csk, double expectedTheta, int expectedEntries, boolean expectedEmpty) {
        boolean emptyOk;
        double actualTheta = csk.getTheta();
        int actualEntries = csk.getRetainedEntries();
        boolean actualEmpty = csk.isEmpty();
        boolean thetaOk = actualTheta == expectedTheta;
        boolean entriesOk = actualEntries == expectedEntries;
        boolean bl = emptyOk = actualEmpty == expectedEmpty;
        if (!(thetaOk && entriesOk && emptyOk)) {
            StringBuilder sb = new StringBuilder();
            sb.append(comment + ": ");
            if (!thetaOk) {
                sb.append("Theta: expected " + expectedTheta + ", got " + actualTheta + "; ");
            }
            if (!entriesOk) {
                sb.append("Entries: expected " + expectedEntries + ", got " + actualEntries + "; ");
            }
            if (!emptyOk) {
                sb.append("Empty: expected " + expectedEmpty + ", got " + actualEmpty + ".");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static UpdatableThetaSketch getSketch(SkType skType, float p, long value) {
        UpdatableThetaSketch sk;
        UpdatableThetaSketchBuilder bldr = UpdatableThetaSketch.builder();
        bldr.setLogNominalEntries(4);
        switch (skType.ordinal()) {
            case 0: {
                sk = bldr.build();
                break;
            }
            case 1: {
                sk = bldr.build();
                sk.update(value);
                break;
            }
            case 2: {
                bldr.setP(p);
                sk = bldr.build();
                sk.update(value);
                break;
            }
            case 3: {
                bldr.setP(p);
                sk = bldr.build();
                sk.update(value);
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static enum SkType {
        EMPTY,
        EXACT,
        ESTIMATION,
        DEGENERATE;

    }
}

