/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectIntersectionTest {
    private static final int PREBYTES = 24;

    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)usk1);
        inter.intersect((ThetaSketch)usk2);
        long[] cache = inter.getCache();
        Assert.assertEquals((int)cache.length, (int)32);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        rsk1 = inter.getResult(false, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 512; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)usk1);
        inter.intersect((ThetaSketch)usk2);
        boolean ordered = true;
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        rsk1 = inter.getResult(false, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, seg);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1024;
        int u = 4096;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (i = 0; i < 4096; ++i) {
            usk1.update((long)i);
        }
        for (i = 2048; i < 6144; ++i) {
            usk2.update((long)i);
        }
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)1024);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)csk1);
        inter.intersect((ThetaSketch)csk2);
        CompactThetaSketch rsk1 = inter.getResult(true, null);
        DirectIntersectionTest.println("" + rsk1.getEstimate());
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void checkIntersectionNull() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        ThetaSketch sk = null;
        try {
            inter.intersect(sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            inter.intersect(sk, sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk);
        CompactThetaSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        sk.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(1L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(1L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdatableThetaSketch.builder().build();
        sk1.update(1L);
        inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        sk2 = UpdatableThetaSketch.builder().build();
        sk2.update(2L);
        inter.intersect((ThetaSketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkOverflow() {
        int lgK = 9;
        int k = 512;
        int reqBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[reqBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 2048; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1est: " + sk1.getEstimate());
        DirectIntersectionTest.println("sk1cnt: " + sk1.getRetainedEntries(true));
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
    }

    @Test
    public void checkHeapify() {
        int i;
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk1);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] byteArray = inter.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        ThetaIntersection inter2 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)seg);
        CompactThetaSketch comp2 = inter2.getResult(false, null);
        double est2 = comp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
    }

    @Test
    public void checkPreject() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setP(0.5f).build();
        sk.update(7L);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
    }

    @Test
    public void checkWrapVirginEmpty() {
        int lgK = 5;
        int k = 32;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)32);
        MemorySegment iSeg = MemorySegment.ofArray(new byte[segBytes]);
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection(iSeg);
        ThetaIntersection inter2 = ThetaIntersection.wrap((MemorySegment)iSeg);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setP(0.5f).setNominalEntries(32).build();
        sk1.update(7L);
        inter1.intersect((ThetaSketch)sk1);
        Assert.assertFalse((boolean)inter1.isEmpty());
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.isEmpty());
        Assert.assertTrue((boolean)inter2.hasResult());
        iSeg = MemorySegment.ofArray(inter1.toByteArray());
        inter2 = ThetaIntersection.wrap((MemorySegment)iSeg);
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactThetaSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test
    public void checkWrapNullEmpty2() {
        int lgK = 5;
        int k = 32;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)32);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection(iSeg);
        ThetaIntersection inter2 = ThetaIntersection.wrap((MemorySegment)iSeg);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setP(0.005f).setFamily(Family.QUICKSELECT).setNominalEntries(32).build();
        sk1.update(1L);
        inter1.intersect((ThetaSketch)sk1);
        inter2 = ThetaIntersection.wrap((MemorySegment)iSeg);
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactThetaSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizeLowerLimit() {
        int k = 8;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)8);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaSetOperation.builder().buildIntersection(iSeg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizedTooSmall() {
        int lgK = 5;
        int k = 32;
        int u = 128;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)16);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        for (int i = 0; i < 128; ++i) {
            usk1.update((long)i);
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)csk1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        int k = 32;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)32);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection(iSeg);
        byte[] byteArray = inter1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)2);
        ThetaIntersection.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 32;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)32);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter1 = ThetaSetOperation.builder().buildIntersection(iSeg);
        byte[] byteArray = inter1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)2);
        ThetaIntersection.wrap((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIncorrectWrap() {
        int k = 32;
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(32).buildUnion();
        byte[] byteArray = union.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        ThetaIntersection.wrap((MemorySegment)seg);
    }

    @Test
    public void checkWrap() {
        int lgK = 9;
        int k = 512;
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)512);
        byte[] segArr1 = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr1);
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        CompactThetaSketch compSkIn1 = sk1.compact(true, null);
        DirectIntersectionTest.println("compSkIn1: " + compSkIn1.getEstimate());
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)compSkIn1);
        byte[] segArr2 = inter.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(segArr2);
        ThetaIntersection inter2 = ThetaIntersection.wrap((MemorySegment)srcSeg);
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        CompactThetaSketch compSkIn2 = sk2.compact(true, null);
        DirectIntersectionTest.println("sk2: " + compSkIn2.getEstimate());
        inter2.intersect((ThetaSketch)compSkIn2);
        CompactThetaSketch resultComp1 = inter2.getResult(false, null);
        double est = resultComp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] segArr3 = inter2.toByteArray();
        MemorySegment srcSeg2 = MemorySegment.ofArray(segArr3);
        ThetaIntersection inter3 = ThetaIntersection.wrap((MemorySegment)srcSeg2);
        CompactThetaSketch resultComp2 = inter3.getResult(false, null);
        double est2 = resultComp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkDefaultMinSize() {
        int k = 32;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        ThetaIntersectionImpl.initNewDirectInstance((long)9001L, (MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptionMinSize() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[152]);
        ThetaIntersectionImpl.initNewDirectInstance((long)9001L, (MemorySegment)seg);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        int segBytes = ThetaSetOperation.getMaxIntersectionBytes((int)1024);
        byte[] segArr = new byte[segBytes];
        MemorySegment iSeg = MemorySegment.ofArray(segArr);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(iSeg);
        inter.intersect((ThetaSketch)sk);
        CompactThetaSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkFamily() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        ThetaIntersectionImpl impl = ThetaIntersectionImpl.initNewDirectInstance((long)9001L, (MemorySegment)seg);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions1() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        ThetaIntersectionImpl.initNewDirectInstance((long)9001L, (MemorySegment)seg);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)2);
        ThetaIntersectionImpl.wrapInstance((MemorySegment)seg, (long)9001L, (boolean)false);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions2() {
        int k = 16;
        MemorySegment seg = MemorySegment.ofArray(new byte[280]);
        ThetaIntersectionImpl.initNewDirectInstance((long)9001L, (MemorySegment)seg);
        Util.setBits((MemorySegment)seg, (long)5L, (byte)4);
        seg.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, 2);
        ThetaIntersectionImpl.wrapInstance((MemorySegment)seg, (long)9001L, (boolean)false);
    }

    @Test
    public void checkOverlappedDirect() {
        int k = 16;
        int segBytes = 536;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            sk1.update((long)i);
            sk2.update((long)(14 + i));
        }
        MemorySegment segIn1 = MemorySegment.ofArray(new byte[536]);
        MemorySegment segIn2 = MemorySegment.ofArray(new byte[536]);
        MemorySegment segInter = MemorySegment.ofArray(new byte[536]);
        MemorySegment segComp = MemorySegment.ofArray(new byte[536]);
        CompactThetaSketch csk1 = sk1.compact(true, segIn1);
        CompactThetaSketch csk2 = sk2.compact(true, segIn2);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection(segInter);
        inter.intersect((ThetaSketch)csk1);
        inter.intersect((ThetaSketch)csk2);
        CompactThetaSketch cskOut = inter.getResult(true, segComp);
        Assert.assertEquals((double)cskOut.getEstimate(), (double)2.0, (double)0.0);
        ThetaIntersection interRO = (ThetaIntersection)ThetaSetOperation.wrap((MemorySegment)segInter.asReadOnly());
        try {
            interRO.intersect((ThetaSketch)sk1, (ThetaSketch)sk2);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            interRO.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        DirectIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

