/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapAlphaSketchTest {
    private Family fam_ = Family.ALPHA;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
        byte[] byteArray = usk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorKtooSmall() {
        int k = 256;
        UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAlphaIncompatibleWithSeg() {
        MemorySegment seg = MemorySegment.ofArray(new byte[8216]);
        UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(512).build(seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
        byte[] byteArray = usk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int k = 512;
        long seed1 = 1021L;
        long seed2 = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed1).setNominalEntries(k).build();
        byte[] byteArray = usk.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)seed2);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCurrentBytes();
        byte[] byteArray = usk.toByteArray();
        Assert.assertEquals((int)bytes, (int)byteArray.length);
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray);
        UpdatableThetaSketch usk2 = (UpdatableThetaSketch)ThetaSketch.heapify((MemorySegment)srcSeg, (long)seed);
        Assert.assertEquals((double)usk2.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)u, (double)0.0);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)u, (double)0.0);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
        usk2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        int u = 2 * k;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)true);
        byte[] byteArray = usk.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        UpdatableThetaSketch usk2 = (UpdatableThetaSketch)ThetaSketch.heapify((MemorySegment)srcSeg, (long)seed);
        Assert.assertEquals((double)usk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
    }

    @Test
    public void checkHeapifyMemorySegmentEstimating() {
        int k = 512;
        int u = 2 * k;
        long seed = 9001L;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        double sk1est = sk1.getEstimate();
        double sk1lb = sk1.getLowerBound(2);
        double sk1ub = sk1.getUpperBound(2);
        Assert.assertTrue((boolean)sk1.isEstimationMode());
        byte[] byteArray = sk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray).asReadOnly();
        UpdatableThetaSketch sk2 = (UpdatableThetaSketch)ThetaSketch.heapify((MemorySegment)seg, (long)9001L);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sk1est);
        Assert.assertEquals((double)sk2.getLowerBound(2), (double)sk1lb);
        Assert.assertEquals((double)sk2.getUpperBound(2), (double)sk1ub);
        Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)sk2.isEstimationMode());
        Assert.assertEquals((String)sk2.getClass().getSimpleName(), (String)sk1.getClass().getSimpleName());
    }

    @Test
    public void checkAlphaToCompactForms() {
        int k = 512;
        int u = 4 * k;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"HeapAlphaSketch");
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        sk1.rebuild();
        Assert.assertTrue((boolean)usk.isEstimationMode());
        CompactThetaSketch comp1 = usk.compact(false, null);
        double comp1est = comp1.getEstimate();
        double comp1lb = comp1.getLowerBound(2);
        double comp1ub = comp1.getUpperBound(2);
        int comp1bytes = comp1.getCompactBytes();
        Assert.assertEquals((int)comp1bytes, (int)comp1.getCurrentBytes());
        int comp1curCount = comp1.getRetainedEntries(true);
        Assert.assertEquals((int)comp1bytes, (int)((comp1curCount << 3) + (Family.COMPACT.getMaxPreLongs() << 3)));
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp1.isEstimationMode());
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactSketch");
        CompactThetaSketch comp2 = usk.compact(true, null);
        Assert.assertEquals((double)comp2.getEstimate(), (double)comp1est);
        Assert.assertEquals((double)comp2.getLowerBound(2), (double)comp1lb);
        Assert.assertEquals((double)comp2.getUpperBound(2), (double)comp1ub);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp2.isEstimationMode());
        Assert.assertEquals((int)comp1bytes, (int)comp2.getCompactBytes());
        Assert.assertEquals((int)comp1curCount, (int)comp2.getRetainedEntries(true));
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactSketch");
        int bytes = usk.getCompactBytes();
        int alphaBytes = sk1.getRetainedEntries(true) * 8;
        Assert.assertEquals((int)bytes, (int)(alphaBytes + (Family.COMPACT.getMaxPreLongs() << 3)));
        byte[] segArr2 = new byte[bytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        CompactThetaSketch comp3 = usk.compact(false, seg2);
        Assert.assertEquals((double)comp3.getEstimate(), (double)comp1est);
        Assert.assertEquals((double)comp3.getLowerBound(2), (double)comp1lb);
        Assert.assertEquals((double)comp3.getUpperBound(2), (double)comp1ub);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp3.isEstimationMode());
        Assert.assertEquals((int)comp1bytes, (int)comp3.getCompactBytes());
        Assert.assertEquals((int)comp1curCount, (int)comp3.getRetainedEntries(true));
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        Util.clear((MemorySegment)seg2);
        CompactThetaSketch comp4 = usk.compact(true, seg2);
        Assert.assertEquals((double)comp4.getEstimate(), (double)comp1est);
        Assert.assertEquals((double)comp4.getLowerBound(2), (double)comp1lb);
        Assert.assertEquals((double)comp4.getUpperBound(2), (double)comp1ub);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp4.isEstimationMode());
        Assert.assertEquals((int)comp1bytes, (int)comp4.getCompactBytes());
        Assert.assertEquals((int)comp1curCount, (int)comp4.getRetainedEntries(true));
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactSketch");
    }

    @Test
    public void checkAlphaToCompactEmptyForms() {
        int k = 512;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        usk.toString(false, true, 0, false);
        boolean estimating = false;
        Assert.assertTrue((boolean)(usk instanceof HeapAlphaSketch));
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)estimating);
        int bytes = usk.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)8);
        byte[] segArr2 = new byte[bytes];
        MemorySegment seg2 = MemorySegment.ofArray(segArr2);
        CompactThetaSketch csk2 = usk.compact(false, seg2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactThetaSketch csk3 = usk.compact(true, seg2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)csk3.isOrdered());
    }

    @Test
    public void checkExactMode() {
        int k = 4096;
        int u = 4096;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 2 * k;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X4).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
    }

    @Test
    public void checkSamplingMode() {
        int k;
        int u = k = 4096;
        float p = 0.5f;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setP(p).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double p2 = sk1.getP();
        double theta = sk1.getTheta();
        Assert.assertTrue((theta <= p2 ? 1 : 0) != 0);
        double est = usk.getEstimate();
        double kdbl = k;
        Assert.assertEquals((double)kdbl, (double)est, (double)(kdbl * 0.05));
        double ub = usk.getUpperBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double lb = usk.getLowerBound(2);
        double ub = usk.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 10 * k;
        for (int i = k; i < u; ++i) {
            usk.update((long)i);
            usk.update((long)i);
        }
        est = usk.getEstimate();
        lb = usk.getLowerBound(2);
        ub = usk.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkEmptyAndP() {
        int k = 1024;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        usk.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)1);
        Assert.assertFalse((boolean)usk.isEmpty());
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setFamily(this.fam_).setP(0.001f).setNominalEntries(k).build();
        sk1 = (HeapAlphaSketch)usk2;
        Assert.assertTrue((boolean)usk2.isEmpty());
        usk2.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)0);
        Assert.assertFalse((boolean)usk2.isEmpty());
        double est = usk2.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        double ub = usk2.getUpperBound(2);
        Assert.assertTrue((ub > 0.0 ? 1 : 0) != 0);
        double lb = usk2.getLowerBound(2);
        Assert.assertTrue((lb <= est ? 1 : 0) != 0);
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int k = 512;
        int u = 2 * k;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X2).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double ub = usk.getUpperBound(1);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int k = 512;
        int u = 4 * k;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertTrue((usk.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)sk1.getRetainedEntries(false), (Object)sk1.getRetainedEntries(true));
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)sk1.getRetainedEntries(true));
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)sk1.getRetainedEntries(true));
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 1024;
        int u = 4 * k;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X8).setNominalEntries(k).build();
        HeapAlphaSketch sk1 = (HeapAlphaSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)(2 * k));
        sk1.reset();
        ResizeFactor rf = sk1.getResizeFactor();
        int subMul = ThetaUtil.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(k).build();
        sk1 = (HeapAlphaSketch)usk2;
        for (int i = 0; i < u; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)(2 * k));
        sk1.reset();
        rf = sk1.getResizeFactor();
        subMul = ThetaUtil.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        Assert.assertNull((Object)sk1.getMemorySegment());
        Assert.assertFalse((boolean)sk1.isOrdered());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkLBlimits0() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        alpha.getLowerBound(0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkUBlimits0() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        alpha.getUpperBound(0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkLBlimits4() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        alpha.getLowerBound(4);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkUBlimits4() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        alpha.getUpperBound(4);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        byte[] byteArray = alpha.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)4);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int k = 512;
        UpdatableThetaSketch alpha = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        alpha.hashUpdate(-1L);
    }

    @Test
    public void checkSegDeSerExceptions() {
        int k = 1024;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        sk1.update(1L);
        byte[] bytearray1 = sk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(bytearray1);
        long pre0 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L);
        HeapAlphaSketchTest.tryBadSeg(seg, 0, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapAlphaSketchTest.tryBadSeg(seg, 1, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapAlphaSketchTest.tryBadSeg(seg, 2, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapAlphaSketchTest.tryBadSeg(seg, 5, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        long origThetaLong = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L);
        try {
            seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, 0x3FFFFFFFFFFFFFFFL);
            HeapAlphaSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, origThetaLong);
        byte[] byteArray2 = new byte[bytearray1.length - 1];
        MemorySegment seg2 = MemorySegment.ofArray(byteArray2);
        MemorySegment.copy(seg, 0L, seg2, 0L, seg2.byteSize());
        try {
            HeapAlphaSketch.heapifyInstance((MemorySegment)seg2, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertLgResizeFactor((MemorySegment)seg, (int)ResizeFactor.X1.lg());
        HeapAlphaSketch usk = HeapAlphaSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
        ResizeFactor rf = usk.getResizeFactor();
        Assert.assertEquals((Object)rf, (Object)ResizeFactor.X2);
    }

    private static void tryBadSeg(MemorySegment seg, int byteOffset, int byteValue) {
        try {
            seg.set(ValueLayout.JAVA_BYTE, (long)byteOffset, (byte)byteValue);
            HeapAlphaSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEnhancedHashInsertOnFullHashTable() {
        HeapAlphaSketch alpha = (HeapAlphaSketch)UpdatableThetaSketch.builder().setFamily(Family.ALPHA).build();
        int n = 1 << alpha.getLgArrLongs();
        long[] hashTable = new long[n];
        for (int i = 1; i <= n; ++i) {
            alpha.enhancedHashInsert(hashTable, (long)i);
        }
        try {
            alpha.enhancedHashInsert(hashTable, (long)(n + 1));
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFamily() {
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setFamily(Family.ALPHA).build();
        Assert.assertEquals((Object)sketch.getFamily(), (Object)Family.ALPHA);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void corruptionLgNomLongs() {
        int k = 512;
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(512).setFamily(Family.ALPHA).build();
        for (int i = 0; i < 512; ++i) {
            sketch.update((long)i);
        }
        byte[] byteArr = sketch.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)8);
        UpdatableThetaSketch.heapify((MemorySegment)wseg);
    }

    @Test
    public void printlnTest() {
        HeapAlphaSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

