/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.thetacommon.HashOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HashOperationsTest {
    @Test(expectedExceptions={SketchesStateException.class})
    public void testThetaCorruption1() {
        HashOperations.checkThetaCorruption((long)0L);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void testThetaCorruption2() {
        HashOperations.checkThetaCorruption((long)-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testHashCorruption() {
        HashOperations.checkHashCorruption((long)-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHashSearch() {
        HashOperations.hashSearch((long[])new long[4], (int)2, (long)0L);
    }

    @Test
    public void checkHashArrayInsert() {
        long[] hTable = new long[16];
        long[] hashIn = new long[1];
        for (int i = 0; i < 8; ++i) {
            hashIn[0] = i;
            long h = MurmurHash3.hash((long[])hashIn, (long)0L)[0] >>> 1;
            HashOperations.hashInsertOnly((long[])hTable, (int)4, (long)h);
            int count = HashOperations.hashArrayInsert((long[])hTable, (long[])hTable, (int)4, (long)Long.MAX_VALUE);
            Assert.assertEquals((int)count, (int)0);
        }
    }

    @Test
    public void testContinueCondtion() {
        long thetaLong = 0x3FFFFFFFFFFFFFFFL;
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0L));
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x4000000000000000L));
        Assert.assertFalse((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x3FFFFFFFFFFFFFFEL));
    }

    @Test
    public void testHashInsertOnlyNoStride() {
        long[] table = new long[32];
        int index = HashOperations.hashInsertOnly((long[])table, (int)5, (long)1L);
        Assert.assertEquals((int)index, (int)1);
        Assert.assertEquals((long)table[1], (long)1L);
    }

    @Test
    public void testHashInsertOnlyWithStride() {
        long[] table = new long[32];
        table[1] = 1L;
        int index = HashOperations.hashInsertOnly((long[])table, (int)5, (long)1L);
        Assert.assertEquals((int)index, (int)2);
        Assert.assertEquals((long)table[2], (long)1L);
    }

    @Test
    public void testHashInsertOnlyMemorySegmentNoStride() {
        long[] table = new long[32];
        MemorySegment seg = MemorySegment.ofArray(table);
        int index = HashOperations.hashInsertOnlyMemorySegment((MemorySegment)seg, (int)5, (long)1L, (int)0);
        Assert.assertEquals((int)index, (int)1);
        Assert.assertEquals((long)table[1], (long)1L);
    }

    @Test
    public void testHashInsertOnlyMemorySegmentWithStride() {
        long[] table = new long[32];
        table[1] = 1L;
        MemorySegment seg = MemorySegment.ofArray(table);
        int index = HashOperations.hashInsertOnlyMemorySegment((MemorySegment)seg, (int)5, (long)1L, (int)0);
        Assert.assertEquals((int)index, (int)2);
        Assert.assertEquals((long)table[2], (long)1L);
    }

    @Test
    public void checkFullHeapTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnly((long[])table, (int)5, (long)i);
        }
        int retVal = HashOperations.hashSearch((long[])table, (int)5, (long)33L);
        Assert.assertEquals((int)retVal, (int)-1);
        try {
            HashOperations.hashInsertOnly((long[])table, (int)5, (long)33L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsert((long[])table, (int)5, (long)33L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFullDirectTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        MemorySegment seg = MemorySegment.ofArray(table);
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnlyMemorySegment((MemorySegment)seg, (int)5, (long)i, (int)0);
        }
        int retVal = HashOperations.hashSearchMemorySegment((MemorySegment)seg, (int)5, (long)33L, (int)0);
        Assert.assertEquals((int)retVal, (int)-1);
        try {
            HashOperations.hashInsertOnlyMemorySegment((MemorySegment)seg, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsertMemorySegment((MemorySegment)seg, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFullFastDirectTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        MemorySegment wseg = MemorySegment.ofArray(table);
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnlyMemorySegment((MemorySegment)wseg, (int)5, (long)i, (int)0);
        }
        try {
            HashOperations.hashInsertOnlyMemorySegment((MemorySegment)wseg, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsertMemorySegment((MemorySegment)wseg, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        HashOperationsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

