/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.UpdatableSummary;

public class IntegerSummary
implements UpdatableSummary<Integer> {
    private int value_;
    private static final int SERIALIZED_SIZE_BYTES = 4;
    private static final int VALUE_INDEX = 0;

    public IntegerSummary(int value) {
        this.value_ = value;
    }

    public IntegerSummary update(Integer value) {
        this.value_ += value.intValue();
        return this;
    }

    public IntegerSummary copy() {
        return new IntegerSummary(this.value_);
    }

    public int getValue() {
        return this.value_;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[4];
        ByteArrayUtil.putIntLE((byte[])bytes, (int)0, (int)this.value_);
        return bytes;
    }

    public static DeserializeResult<IntegerSummary> fromMemorySegment(MemorySegment seg) {
        return new DeserializeResult((Object)new IntegerSummary(seg.get(ValueLayout.JAVA_INT_UNALIGNED, 0L)), 4);
    }
}

