/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.JaccardSimilarity;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JaccardSimilarityTest {
    private final DoubleSummary.Mode umode = DoubleSummary.Mode.Sum;
    private final DoubleSummarySetOperations dsso = new DoubleSummarySetOperations();
    private final DoubleSummaryFactory factory = new DoubleSummaryFactory(this.umode);
    private final UpdatableThetaSketchBuilder thetaBldr = UpdatableThetaSketch.builder();
    private final UpdatableTupleSketchBuilder<Double, DoubleSummary> tupleBldr = new UpdatableTupleSketchBuilder((SummaryFactory)this.factory);
    private final Double constSummary = 1.0;

    @Test
    public void checkNullsEmpties1() {
        int minK = 4096;
        double threshold = 0.95;
        JaccardSimilarityTest.println("Check nulls & empties, minK: " + minK + "\t Th: " + threshold);
        double[] jResults = JaccardSimilarity.jaccard(null, null, (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println("null \t null:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual(null, null, (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).build();
        UpdatableTupleSketch expected = this.tupleBldr.setNominalEntries(minK).build();
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\tempty:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)measured, (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        expected.update(1L, (Object)this.constSummary);
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\t    1:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkNullsEmpties2() {
        int minK = 4096;
        double threshold = 0.95;
        JaccardSimilarityTest.println("Check nulls & empties, minK: " + minK + "\t Th: " + threshold);
        double[] jResults = JaccardSimilarity.jaccard(null, null, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println("null \t null:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual(null, null, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).build();
        UpdatableThetaSketch expected = this.thetaBldr.setNominalEntries(minK).build();
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\tempty:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)measured, (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        expected.update(1L);
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\t    1:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkExactMode1() {
        int k;
        int u = k = 4096;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Exact Mode, minK: " + k + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(k).build();
        UpdatableTupleSketch expected = this.tupleBldr.setNominalEntries(k).build();
        for (int i = 0; i < u - 1; ++i) {
            measured.update((long)i, (Object)this.constSummary);
            expected.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        measured.update((long)(u - 1), (Object)this.constSummary);
        expected.update((long)u, (Object)this.constSummary);
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkExactMode2() {
        int k;
        int u = k = 4096;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Exact Mode, minK: " + k + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(k).build();
        UpdatableThetaSketch expected = this.thetaBldr.setNominalEntries(k).build();
        for (int i = 0; i < u - 1; ++i) {
            measured.update((long)i, (Object)this.constSummary);
            expected.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        measured.update((long)(u - 1), (Object)this.constSummary);
        expected.update((long)u);
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkEstMode1() {
        int k = 4096;
        int u = 0x100000;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + k + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(k).build();
        UpdatableTupleSketch expected = this.tupleBldr.setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            measured.update((long)i, (Object)this.constSummary);
            expected.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        for (int i = u; i < u + 50; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        state = jResults[1] >= threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkEstMode2() {
        int k = 4096;
        int u = 0x100000;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + k + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(k).build();
        UpdatableThetaSketch expected = this.thetaBldr.setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            measured.update((long)i, (Object)this.constSummary);
            expected.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertTrue((boolean)state);
        for (int i = u; i < u + 50; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        state = jResults[1] >= threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkSimilarity1() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.95);
        double threshold = 0.943;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).build();
        UpdatableTupleSketch expected = this.tupleBldr.setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        boolean state = JaccardSimilarity.similarityTest((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.similarityTest((TupleSketch)measured, (TupleSketch)measured, (SummarySetOperations)this.dsso, (double)threshold);
        Assert.assertTrue((boolean)state);
    }

    @Test
    public void checkSimilarity2() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.95);
        double threshold = 0.943;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).build();
        UpdatableThetaSketch expected = this.thetaBldr.setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        boolean state = JaccardSimilarity.similarityTest((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.similarityTest((TupleSketch)measured, (TupleSketch)measured, (SummarySetOperations)this.dsso, (double)threshold);
        Assert.assertTrue((boolean)state);
    }

    @Test
    public void checkDissimilarity1() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.05);
        double threshold = 0.061;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).setNominalEntries(minK).build();
        UpdatableTupleSketch expected = this.tupleBldr.setNominalEntries(minK).setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso);
        boolean state = JaccardSimilarity.dissimilarityTest((TupleSketch)measured, (TupleSketch)expected, (SummarySetOperations)this.dsso, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
    }

    @Test
    public void checkDissimilarity2() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.05);
        double threshold = 0.061;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdatableTupleSketch measured = this.tupleBldr.setNominalEntries(minK).setNominalEntries(minK).build();
        UpdatableThetaSketch expected = this.thetaBldr.setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i, (Object)this.constSummary);
        }
        double[] jResults = JaccardSimilarity.jaccard((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        boolean state = JaccardSimilarity.dissimilarityTest((TupleSketch)measured, (ThetaSketch)expected, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
    }

    private static String jaccardString(double[] jResults) {
        double lb = jResults[0];
        double est = jResults[1];
        double ub = jResults[2];
        return lb + "\t" + est + "\t" + ub + "\t" + (lb / est - 1.0) + "\t" + (ub / est - 1.0);
    }

    @Test
    public void checkMinK1() {
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableTupleSketch skB = this.tupleBldr.build();
        skA.update(1L, (Object)this.constSummary);
        skB.update(1L, (Object)this.constSummary);
        double[] result = JaccardSimilarity.jaccard((TupleSketch)skA, (TupleSketch)skB, (SummarySetOperations)this.dsso);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
        for (int i = 1; i < 4096; ++i) {
            skA.update((long)i, (Object)this.constSummary);
            skB.update((long)i, (Object)this.constSummary);
        }
        result = JaccardSimilarity.jaccard((TupleSketch)skA, (TupleSketch)skB, (SummarySetOperations)this.dsso);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
    }

    @Test
    public void checkMinK2() {
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableThetaSketch skB = UpdatableThetaSketch.builder().build();
        skA.update(1L, (Object)this.constSummary);
        skB.update(1L);
        double[] result = JaccardSimilarity.jaccard((TupleSketch)skA, (ThetaSketch)skB, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
        for (int i = 1; i < 4096; ++i) {
            skA.update((long)i, (Object)this.constSummary);
            skB.update((long)i);
        }
        result = JaccardSimilarity.jaccard((TupleSketch)skA, (ThetaSketch)skB, (Summary)this.factory.newSummary(), (SummarySetOperations)this.dsso);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
    }

    @Test
    public void printlnTest() {
        JaccardSimilarityTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

