/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.IntegerSummary;
import org.apache.datasketches.tuple.IntegerSummaryDeserializer;
import org.apache.datasketches.tuple.IntegerSummaryFactory;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleCrossLanguageTest {
    @Test(groups={"check_cpp_historical_files"})
    public void serialVersion1Compatibility() {
        byte[] byteArr = TestUtil.getResourceBytes("CompactSketchWithDoubleSummary4K_serialVersion1.sk");
        TupleSketch sketch = TupleSketch.heapifySketch((MemorySegment)MemorySegment.ofArray(byteArr), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8192.0, (double)8110.08);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)4096);
        int count = 0;
        TupleSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void version2Compatibility() {
        byte[] byteArr = TestUtil.getResourceBytes("TupleWithTestIntegerSummary4kTrimmedSerVer2.sk");
        TupleSketch sketch1 = TupleSketch.heapifySketch((MemorySegment)MemorySegment.ofArray(byteArr), (SummaryDeserializer)new IntegerSummaryDeserializer());
        int lgK = 12;
        int K = 4096;
        UpdatableTupleSketchBuilder builder = new UpdatableTupleSketchBuilder((SummaryFactory)new IntegerSummaryFactory());
        UpdatableTupleSketch updatableSketch = builder.build();
        for (int i = 0; i < 8192; ++i) {
            updatableSketch.update((long)i, (Object)1);
        }
        updatableSketch.trim();
        CompactTupleSketch sketch2 = updatableSketch.compact();
        Assert.assertEquals((int)sketch1.getRetainedEntries(), (int)sketch2.getRetainedEntries());
        Assert.assertEquals((long)sketch1.getThetaLong(), (long)sketch2.getThetaLong());
        Assert.assertEquals((boolean)sketch1.isEmpty(), (boolean)sketch2.isEmpty());
        Assert.assertEquals((boolean)sketch1.isEstimationMode(), (boolean)sketch2.isEstimationMode());
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppIntegerSummary() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("tuple_int_n" + n + "_cpp.sk"));
            TupleSketch sketch = TupleSketch.heapifySketch((MemorySegment)MemorySegment.ofArray(bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertTrue((boolean)(n > 1000 ? sketch.isEstimationMode() : !sketch.isEstimationMode()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            TupleSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getHash() < sketch.getThetaLong() ? 1 : 0) != 0);
                Assert.assertTrue((((IntegerSummary)it.getSummary()).getValue() < n ? 1 : 0) != 0);
            }
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateForCppIntegerSummary() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            UpdatableTupleSketch sk = new UpdatableTupleSketchBuilder((SummaryFactory)new IntegerSummaryFactory()).build();
            for (int i = 0; i < n; ++i) {
                sk.update((long)i, (Object)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("tuple_int_n" + n + "_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class}, groups={"check_cpp_historical_files"})
    public void noSupportHeapifyV0_9_1() throws Exception {
        byte[] byteArr = TestUtil.getResourceBytes("ArrayOfDoublesUnion_v0.9.1.sk");
        ArrayOfDoublesUnion.heapify((MemorySegment)MemorySegment.ofArray(byteArr));
    }

    @Test(expectedExceptions={SketchesArgumentException.class}, groups={"check_cpp_historical_files"})
    public void noSupportWrapV0_9_1() throws Exception {
        byte[] byteArr = TestUtil.getResourceBytes("ArrayOfDoublesUnion_v0.9.1.sk");
        ArrayOfDoublesUnion.wrap((MemorySegment)MemorySegment.ofArray(byteArr));
    }
}

