/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCombiner;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesIntersection;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesIntersectionTest {
    private static ArrayOfDoublesCombiner combiner = new ArrayOfDoublesCombiner(){

        public double[] combine(double[] a, double[] b) {
            for (int i = 0; i < a.length; ++i) {
                int n = i;
                a[n] = a[n] + b[i];
            }
            return a;
        }
    };

    @Test
    public void nullInput() {
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        try {
            intersection.intersect(null, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void empty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void degenerateWithExact() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(0.01f).build();
        sketch1.update("a", new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(1L, new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, null);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)184.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void heapExactWithEmpty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(3L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, null);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void directExactWithEmpty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(3L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(MemorySegment.ofArray(new byte[1000000]));
        intersection.intersect((ArrayOfDoublesSketch)sketch1, null);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void heapExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertEquals((double)result.getEstimate(), (double)1.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)1.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)4.0);
        }
        intersection.reset();
        try {
            intersection.intersect(null, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void heapDisjointEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
        Assert.assertTrue((result.thetaLong_ < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void directDisjointEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(MemorySegment.ofArray(new byte[1000000]));
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void heapEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)2.0);
        }
    }

    @Test
    public void directEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(MemorySegment.ofArray(new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(MemorySegment.ofArray(new byte[1000000]));
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)2.0);
        }
    }

    @Test
    public void heapExactModeCustomSeed() {
        long seed = 1234567890L;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1234567890L).build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1234567890L).build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().setSeed(1234567890L).buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.intersect((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertEquals((double)result.getEstimate(), (double)1.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)1.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((double)values[i][0], (double)4.0);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeeds() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().setSeed(2L).buildIntersection();
        intersection.intersect((ArrayOfDoublesSketch)sketch, combiner);
    }
}

