/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectHll4Array;
import org.apache.datasketches.hll.DirectHll6Array;
import org.apache.datasketches.hll.Hll4Array;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

public class HllUnion
extends BaseHllSketch {
    final int lgMaxK;
    private final HllSketch gadget;

    public HllUnion() {
        this.lgMaxK = 12;
        this.gadget = new HllSketch(this.lgMaxK, TgtHllType.HLL_8);
    }

    public HllUnion(int lgMaxK) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8);
    }

    public HllUnion(int lgMaxK, MemorySegment dstWseg) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8, dstWseg);
    }

    private HllUnion(HllSketch sketch) {
        this.lgMaxK = sketch.getLgConfigK();
        this.gadget = sketch;
    }

    public static final HllUnion heapify(byte[] byteArray) {
        return HllUnion.heapify(MemorySegment.ofArray(byteArray));
    }

    public static final HllUnion heapify(MemorySegment seg) {
        int lgK = HllUtil.checkLgK(seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.LG_K_BYTE));
        HllSketch sk = HllSketch.heapify(seg, false);
        HllUnion union = new HllUnion(lgK);
        union.update(sk);
        return union;
    }

    public static final HllUnion writableWrap(MemorySegment srcWseg) {
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(srcWseg);
        if (tgtHllType != TgtHllType.HLL_8) {
            throw new SketchesArgumentException("HllUnion can only wrap writable HLL_8 sketches that were the Gadget of a HllUnion.");
        }
        return new HllUnion(HllSketch.writableWrap(srcWseg, false));
    }

    @Override
    public double getCompositeEstimate() {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.hllSketchImpl.getCompositeEstimate();
    }

    @Override
    CurMode getCurMode() {
        return this.gadget.getCurMode();
    }

    @Override
    public int getCompactSerializationBytes() {
        return this.gadget.getCompactSerializationBytes();
    }

    @Override
    public double getEstimate() {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.getEstimate();
    }

    @Override
    public int getLgConfigK() {
        return this.gadget.getLgConfigK();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.getLowerBound(numStdDev);
    }

    public static int getMaxSerializationBytes(int lgK) {
        return HllSketch.getMaxUpdatableSerializationBytes(lgK, TgtHllType.HLL_8);
    }

    public HllSketch getResult() {
        return this.getResult(HllSketch.DEFAULT_HLL_TYPE);
    }

    public HllSketch getResult(TgtHllType tgtHllType) {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.copyAs(tgtHllType);
    }

    @Override
    public TgtHllType getTgtHllType() {
        return TgtHllType.HLL_8;
    }

    @Override
    public int getUpdatableSerializationBytes() {
        return this.gadget.getUpdatableSerializationBytes();
    }

    @Override
    public double getUpperBound(int numStdDev) {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.getUpperBound(numStdDev);
    }

    @Override
    public boolean isCompact() {
        return this.gadget.isCompact();
    }

    @Override
    public boolean isEmpty() {
        return this.gadget.isEmpty();
    }

    @Override
    public boolean hasMemorySegment() {
        return this.gadget.hasMemorySegment();
    }

    @Override
    public boolean isOffHeap() {
        return this.gadget.isOffHeap();
    }

    @Override
    boolean isOutOfOrder() {
        return this.gadget.isOutOfOrder();
    }

    @Override
    public boolean isSameResource(MemorySegment seg) {
        return this.gadget.isSameResource(seg);
    }

    boolean isRebuildCurMinNumKxQFlag() {
        return this.gadget.hllSketchImpl.isRebuildCurMinNumKxQFlag();
    }

    void putRebuildCurMinNumKxQFlag(boolean rebuild) {
        this.gadget.hllSketchImpl.putRebuildCurMinNumKxQFlag(rebuild);
    }

    @Override
    public void reset() {
        this.gadget.reset();
    }

    @Override
    public byte[] toCompactByteArray() {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.toCompactByteArray();
    }

    @Override
    public byte[] toUpdatableByteArray() {
        HllUnion.checkRebuildCurMinNumKxQ(this.gadget);
        return this.gadget.toUpdatableByteArray();
    }

    @Override
    public String toString(boolean summary, boolean hllDetail, boolean auxDetail, boolean all) {
        HllSketch clone = this.gadget.copy();
        HllUnion.checkRebuildCurMinNumKxQ(clone);
        return clone.toString(summary, hllDetail, auxDetail, all);
    }

    public void update(HllSketch sketch) {
        this.gadget.hllSketchImpl = HllUnion.unionImpl(sketch, this.gadget, this.lgMaxK);
    }

    @Override
    void couponUpdate(int coupon) {
        if (coupon == 0) {
            return;
        }
        this.gadget.hllSketchImpl = this.gadget.hllSketchImpl.couponUpdate(coupon);
    }

    private static HllSketchImpl unionImpl(HllSketch source, HllSketch gadget, int lgMaxK) {
        assert (gadget.getTgtHllType() == TgtHllType.HLL_8);
        if (source == null || source.isEmpty()) {
            return gadget.hllSketchImpl;
        }
        CurMode srcMode = source.getCurMode();
        if (srcMode == CurMode.LIST) {
            source.mergeTo(gadget);
            return gadget.hllSketchImpl;
        }
        int srcLgK = source.getLgConfigK();
        int gadgetLgK = gadget.getLgConfigK();
        boolean srcHasSeg = source.hasMemorySegment();
        boolean gdtHasSeg = gadget.hasMemorySegment();
        boolean gdtEmpty = gadget.isEmpty();
        if (srcMode == CurMode.SET) {
            if (gdtEmpty && srcLgK == gadgetLgK && !srcHasSeg && !gdtHasSeg) {
                gadget.hllSketchImpl = source.copyAs((TgtHllType)TgtHllType.HLL_8).hllSketchImpl;
                return gadget.hllSketchImpl;
            }
            source.mergeTo(gadget);
            return gadget.hllSketchImpl;
        }
        int bit0 = gdtHasSeg ? 1 : 0;
        int bits1_2 = (gdtEmpty ? 3 : gadget.getCurMode().ordinal()) << 1;
        int bit3 = srcLgK < gadgetLgK ? 8 : 0;
        int bit4 = srcLgK > lgMaxK ? 16 : 0;
        int sw = bit4 | bit3 | bits1_2 | bit0;
        HllSketchImpl hllSketchImpl = null;
        switch (sw) {
            case 0: 
            case 2: 
            case 8: 
            case 10: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 16: 
            case 18: {
                HllSketch srcHll8Heap = HllUnion.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                gadget.mergeTo(srcHll8Heap);
                hllSketchImpl = HllUnion.useGadgetMemorySegment((HllSketch)gadget, (HllSketch)srcHll8Heap, (boolean)false).hllSketchImpl;
                break;
            }
            case 17: 
            case 19: {
                HllSketch srcHll8Heap = HllUnion.downsample(source, lgMaxK);
                gadget.mergeTo(srcHll8Heap);
                hllSketchImpl = HllUnion.useGadgetMemorySegment((HllSketch)gadget, (HllSketch)srcHll8Heap, (boolean)false).hllSketchImpl;
                break;
            }
            case 4: 
            case 5: 
            case 20: 
            case 21: {
                HllUnion.mergeHlltoHLLmode(source, gadget, srcLgK, gadgetLgK, srcHasSeg, gdtHasSeg);
                hllSketchImpl = gadget.putOutOfOrderFlag((boolean)true).hllSketchImpl;
                break;
            }
            case 12: {
                HllSketch gdtHll8Heap = HllUnion.downsample(gadget, srcLgK);
                HllUnion.mergeHlltoHLLmode(source, gdtHll8Heap, srcLgK, gadgetLgK, srcHasSeg, false);
                hllSketchImpl = gdtHll8Heap.putOutOfOrderFlag((boolean)true).hllSketchImpl;
                break;
            }
            case 13: {
                HllSketch gdtHll8Heap = HllUnion.downsample(gadget, srcLgK);
                HllUnion.mergeHlltoHLLmode(source, gdtHll8Heap, srcLgK, gadgetLgK, srcHasSeg, false);
                hllSketchImpl = HllUnion.useGadgetMemorySegment((HllSketch)gadget, (HllSketch)gdtHll8Heap, (boolean)true).hllSketchImpl;
                break;
            }
            case 6: 
            case 14: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 22: {
                HllSketch srcHll8Heap = HllUnion.downsample(source, lgMaxK);
                hllSketchImpl = srcHll8Heap.hllSketchImpl;
                break;
            }
            case 7: 
            case 15: {
                HllSketch srcHll8Heap = source.copyAs(TgtHllType.HLL_8);
                hllSketchImpl = HllUnion.useGadgetMemorySegment((HllSketch)gadget, (HllSketch)srcHll8Heap, (boolean)false).hllSketchImpl;
                break;
            }
            case 23: {
                HllSketch srcHll8Heap = HllUnion.downsample(source, lgMaxK);
                hllSketchImpl = HllUnion.useGadgetMemorySegment((HllSketch)gadget, (HllSketch)srcHll8Heap, (boolean)false).hllSketchImpl;
                break;
            }
            default: {
                return gadget.hllSketchImpl;
            }
        }
        return hllSketchImpl;
    }

    private static final HllSketch useGadgetMemorySegment(HllSketch gadget, HllSketch hll8Heap, boolean setOooFlag) {
        MemorySegment wseg = gadget.getMemorySegment();
        byte[] byteArr = hll8Heap.toUpdatableByteArray();
        MemorySegment.copy(byteArr, 0, wseg, ValueLayout.JAVA_BYTE, 0L, byteArr.length);
        return setOooFlag ? HllSketch.writableWrap(wseg, false).putOutOfOrderFlag(true) : HllSketch.writableWrap(wseg, false);
    }

    private static final void mergeHlltoHLLmode(HllSketch src, HllSketch tgt, int srcLgK, int tgtLgK, boolean srcHasSeg, boolean tgtHasSeg) {
        int sw = (tgtHasSeg ? 1 : 0) | (srcHasSeg ? 2 : 0) | (srcLgK > tgtLgK ? 4 : 0) | (src.getTgtHllType() != TgtHllType.HLL_8 ? 8 : 0);
        int srcK = 1 << srcLgK;
        switch (sw) {
            case 0: {
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    byte tgtV = tgtArr[i];
                    tgtArr[i] = (byte)Math.max(srcV, tgtV);
                }
                break;
            }
            case 1: {
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                MemorySegment tgtSeg = tgt.getMemorySegment();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    byte tgtV = tgtSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtSeg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i), (byte)Math.max(srcV, tgtV));
                }
                break;
            }
            case 2: {
                MemorySegment srcSeg = src.getMemorySegment();
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    byte tgtV = tgtArr[i];
                    tgtArr[i] = (byte)Math.max(srcV, tgtV);
                }
                break;
            }
            case 3: {
                MemorySegment srcSeg = src.getMemorySegment();
                MemorySegment tgtSeg = tgt.getMemorySegment();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    byte tgtV = tgtSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    tgtSeg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i), (byte)Math.max(srcV, tgtV));
                }
                break;
            }
            case 4: {
                int tgtKmask = (1 << tgtLgK) - 1;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    int j = i & tgtKmask;
                    byte tgtV = tgtArr[j];
                    tgtArr[j] = (byte)Math.max(srcV, tgtV);
                }
                break;
            }
            case 5: {
                int tgtKmask = (1 << tgtLgK) - 1;
                byte[] srcArr = ((Hll8Array)src.hllSketchImpl).hllByteArr;
                MemorySegment tgtSeg = tgt.getMemorySegment();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcArr[i];
                    int j = i & tgtKmask;
                    byte tgtV = tgtSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + j));
                    tgtSeg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + j), (byte)Math.max(srcV, tgtV));
                }
                break;
            }
            case 6: {
                int tgtKmask = (1 << tgtLgK) - 1;
                MemorySegment srcSeg = src.getMemorySegment();
                byte[] tgtArr = ((Hll8Array)tgt.hllSketchImpl).hllByteArr;
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    int j = i & tgtKmask;
                    byte tgtV = tgtArr[j];
                    tgtArr[j] = (byte)Math.max(srcV, tgtV);
                }
                break;
            }
            case 7: {
                int tgtKmask = (1 << tgtLgK) - 1;
                MemorySegment srcSeg = src.getMemorySegment();
                MemorySegment tgtSeg = tgt.getMemorySegment();
                for (int i = 0; i < srcK; ++i) {
                    byte srcV = srcSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i));
                    int j = i & tgtKmask;
                    byte tgtV = tgtSeg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + j));
                    tgtSeg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + j), (byte)Math.max(srcV, tgtV));
                }
                break;
            }
            case 8: 
            case 9: {
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                if (src.getTgtHllType() == TgtHllType.HLL_4) {
                    Hll4Array src4 = (Hll4Array)src.hllSketchImpl;
                    AuxHashMap auxHashMap = src4.getAuxHashMap();
                    int curMin = src4.getCurMin();
                    int i = 0;
                    for (int j = 0; j < srcK; ++j) {
                        byte b;
                        int value;
                        tgtAbsHllArr.updateSlotNoKxQ(j, (value = Byte.toUnsignedInt(b = src4.hllByteArr[i++]) & 0xF) == 15 ? auxHashMap.mustFindValueFor(j) : value + curMin);
                        value = Byte.toUnsignedInt(b) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j, value == 15 ? auxHashMap.mustFindValueFor(++j) : value + curMin);
                    }
                } else {
                    Hll6Array src6 = (Hll6Array)src.hllSketchImpl;
                    int i = 0;
                    int j = 0;
                    while (j < srcK) {
                        byte b1 = src6.hllByteArr[i++];
                        byte b2 = src6.hllByteArr[i++];
                        byte b3 = src6.hllByteArr[i++];
                        int value = Byte.toUnsignedInt(b1) & 0x3F;
                        tgtAbsHllArr.updateSlotNoKxQ(j++, value);
                        value = Byte.toUnsignedInt(b1) >>> 6;
                        tgtAbsHllArr.updateSlotNoKxQ(j++, value |= (Byte.toUnsignedInt(b2) & 0xF) << 2);
                        value = Byte.toUnsignedInt(b2) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j++, value |= (Byte.toUnsignedInt(b3) & 3) << 4);
                        value = Byte.toUnsignedInt(b3) >>> 2;
                        tgtAbsHllArr.updateSlotNoKxQ(j++, value);
                    }
                }
                break;
            }
            case 10: 
            case 11: {
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                if (src.getTgtHllType() == TgtHllType.HLL_4) {
                    DirectHll4Array src4 = (DirectHll4Array)src.hllSketchImpl;
                    AuxHashMap auxHashMap = src4.getAuxHashMap();
                    int curMin = src4.getCurMin();
                    int i = 0;
                    for (int j = 0; j < srcK; ++j) {
                        byte b;
                        int value;
                        tgtAbsHllArr.updateSlotNoKxQ(j, (value = Byte.toUnsignedInt(b = src4.seg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i++))) & 0xF) == 15 ? auxHashMap.mustFindValueFor(j) : value + curMin);
                        value = Byte.toUnsignedInt(b) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j, value == 15 ? auxHashMap.mustFindValueFor(++j) : value + curMin);
                    }
                } else {
                    DirectHll6Array src6 = (DirectHll6Array)src.hllSketchImpl;
                    int i = 0;
                    int offset = PreambleUtil.HLL_BYTE_ARR_START;
                    while (i < srcK) {
                        byte b1 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        byte b2 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        byte b3 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        int value = Byte.toUnsignedInt(b1) & 0x3F;
                        tgtAbsHllArr.updateSlotNoKxQ(i++, value);
                        value = Byte.toUnsignedInt(b1) >>> 6;
                        tgtAbsHllArr.updateSlotNoKxQ(i++, value |= (Byte.toUnsignedInt(b2) & 0xF) << 2);
                        value = Byte.toUnsignedInt(b2) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(i++, value |= (Byte.toUnsignedInt(b3) & 3) << 4);
                        value = Byte.toUnsignedInt(b3) >>> 2;
                        tgtAbsHllArr.updateSlotNoKxQ(i++, value);
                    }
                }
                break;
            }
            case 12: 
            case 13: {
                int tgtKmask = (1 << tgtLgK) - 1;
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                if (src.getTgtHllType() == TgtHllType.HLL_4) {
                    Hll4Array src4 = (Hll4Array)src.hllSketchImpl;
                    AuxHashMap auxHashMap = src4.getAuxHashMap();
                    int curMin = src4.getCurMin();
                    int i = 0;
                    for (int j = 0; j < srcK; ++j) {
                        byte b;
                        int value;
                        tgtAbsHllArr.updateSlotNoKxQ(j & tgtKmask, (value = Byte.toUnsignedInt(b = src4.hllByteArr[i++]) & 0xF) == 15 ? auxHashMap.mustFindValueFor(j) : value + curMin);
                        value = Byte.toUnsignedInt(b) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j & tgtKmask, value == 15 ? auxHashMap.mustFindValueFor(++j) : value + curMin);
                    }
                } else {
                    Hll6Array src6 = (Hll6Array)src.hllSketchImpl;
                    int i = 0;
                    int j = 0;
                    while (j < srcK) {
                        byte b1 = src6.hllByteArr[i++];
                        byte b2 = src6.hllByteArr[i++];
                        byte b3 = src6.hllByteArr[i++];
                        int value = Byte.toUnsignedInt(b1) & 0x3F;
                        tgtAbsHllArr.updateSlotNoKxQ(j++ & tgtKmask, value);
                        value = Byte.toUnsignedInt(b1) >>> 6;
                        tgtAbsHllArr.updateSlotNoKxQ(j++ & tgtKmask, value |= (Byte.toUnsignedInt(b2) & 0xF) << 2);
                        value = Byte.toUnsignedInt(b2) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j++ & tgtKmask, value |= (Byte.toUnsignedInt(b3) & 3) << 4);
                        value = Byte.toUnsignedInt(b3) >>> 2;
                        tgtAbsHllArr.updateSlotNoKxQ(j++ & tgtKmask, value);
                    }
                }
                break;
            }
            case 14: 
            case 15: {
                int tgtKmask = (1 << tgtLgK) - 1;
                AbstractHllArray tgtAbsHllArr = (AbstractHllArray)tgt.hllSketchImpl;
                if (src.getTgtHllType() == TgtHllType.HLL_4) {
                    DirectHll4Array src4 = (DirectHll4Array)src.hllSketchImpl;
                    AuxHashMap auxHashMap = src4.getAuxHashMap();
                    int curMin = src4.getCurMin();
                    int i = 0;
                    for (int j = 0; j < srcK; ++j) {
                        byte b;
                        int value;
                        tgtAbsHllArr.updateSlotNoKxQ(j & tgtKmask, (value = Byte.toUnsignedInt(b = src4.seg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + i++))) & 0xF) == 15 ? auxHashMap.mustFindValueFor(j) : value + curMin);
                        value = Byte.toUnsignedInt(b) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(j & tgtKmask, value == 15 ? auxHashMap.mustFindValueFor(++j) : value + curMin);
                    }
                } else {
                    DirectHll6Array src6 = (DirectHll6Array)src.hllSketchImpl;
                    int i = 0;
                    int offset = PreambleUtil.HLL_BYTE_ARR_START;
                    while (i < srcK) {
                        byte b1 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        byte b2 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        byte b3 = src6.seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                        int value = Byte.toUnsignedInt(b1) & 0x3F;
                        tgtAbsHllArr.updateSlotNoKxQ(i++ & tgtKmask, value);
                        value = Byte.toUnsignedInt(b1) >>> 6;
                        tgtAbsHllArr.updateSlotNoKxQ(i++ & tgtKmask, value |= (Byte.toUnsignedInt(b2) & 0xF) << 2);
                        value = Byte.toUnsignedInt(b2) >>> 4;
                        tgtAbsHllArr.updateSlotNoKxQ(i++ & tgtKmask, value |= (Byte.toUnsignedInt(b3) & 3) << 4);
                        value = Byte.toUnsignedInt(b3) >>> 2;
                        tgtAbsHllArr.updateSlotNoKxQ(i++ & tgtKmask, value);
                    }
                }
                break;
            }
        }
        tgt.hllSketchImpl.putRebuildCurMinNumKxQFlag(true);
    }

    private static final HllSketch downsample(HllSketch candidate, int tgtLgK) {
        AbstractHllArray candArr = (AbstractHllArray)candidate.hllSketchImpl;
        HllArray tgtHllArr = HllArray.newHeapHll(tgtLgK, TgtHllType.HLL_8);
        PairIterator candItr = candArr.iterator();
        while (candItr.nextValid()) {
            tgtHllArr.couponUpdate(candItr.getPair());
        }
        tgtHllArr.putHipAccum(candArr.getHipAccum());
        tgtHllArr.putOutOfOrder(candidate.isOutOfOrder());
        tgtHllArr.putRebuildCurMinNumKxQFlag(false);
        return new HllSketch(tgtHllArr);
    }

    static final void checkRebuildCurMinNumKxQ(HllSketch sketch) {
        HllSketchImpl hllSketchImpl = sketch.hllSketchImpl;
        CurMode curMode = sketch.getCurMode();
        TgtHllType tgtHllType = sketch.getTgtHllType();
        boolean rebuild = hllSketchImpl.isRebuildCurMinNumKxQFlag();
        if (!rebuild || curMode != CurMode.HLL || tgtHllType != TgtHllType.HLL_8) {
            return;
        }
        AbstractHllArray absHllArr = (AbstractHllArray)hllSketchImpl;
        int curMin = 64;
        int numAtCurMin = 0;
        double kxq0 = 1 << absHllArr.getLgConfigK();
        double kxq1 = 0.0;
        PairIterator itr = absHllArr.iterator();
        while (itr.nextAll()) {
            int v = itr.getValue();
            if (v > 0) {
                if (v < 32) {
                    kxq0 += Util.invPow2(v) - 1.0;
                } else {
                    kxq1 += Util.invPow2(v) - 1.0;
                }
            }
            if (v > curMin) continue;
            if (v < curMin) {
                curMin = v;
                numAtCurMin = 1;
                continue;
            }
            ++numAtCurMin;
        }
        absHllArr.putKxQ0(kxq0);
        absHllArr.putKxQ1(kxq1);
        absHllArr.putCurMin(curMin);
        absHllArr.putNumAtCurMin(numAtCurMin);
        absHllArr.putRebuildCurMinNumKxQFlag(false);
    }
}

