/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.datasketches.sampling.VarOptItemsSketch;

public class VarOptItemsSamples<T>
implements Iterable<WeightedSample> {
    final VarOptItemsSketch<T> sketch_;
    VarOptItemsSketch.Result sampleLists;
    final long n_;
    final int h_;
    final double rWeight_;

    VarOptItemsSamples(VarOptItemsSketch<T> sketch) {
        Objects.requireNonNull(sketch, "sketch must not be null");
        this.sketch_ = sketch;
        this.n_ = sketch.getN();
        this.h_ = sketch.getHRegionCount();
        this.rWeight_ = sketch.getTau();
    }

    @Override
    public Iterator<WeightedSample> iterator() {
        return new VarOptItemsIterator(this);
    }

    Iterator<WeightedSample> getHIterator() {
        return new VarOptItemsIterator(this, false);
    }

    Iterator<WeightedSample> getRIterator() {
        return new VarOptItemsIterator(this, true);
    }

    Iterator<WeightedSample> getWeightCorrRIter() {
        return new WeightCorrectingRRegionIterator(this);
    }

    public void setClass(Class<?> clazz) {
        if (this.sampleLists == null) {
            this.sampleLists = this.sketch_.getSamplesAsArrays(clazz);
        }
    }

    public int getNumSamples() {
        this.loadArrays();
        return this.sampleLists == null || this.sampleLists.weights == null ? 0 : this.sampleLists.weights.length;
    }

    public T[] items() {
        this.loadArrays();
        return this.sampleLists == null ? null : this.sampleLists.items;
    }

    public T items(int i) {
        this.loadArrays();
        return this.sampleLists == null || this.sampleLists.items == null ? null : (T)this.sampleLists.items[i];
    }

    public double[] weights() {
        this.loadArrays();
        return this.sampleLists == null ? null : this.sampleLists.weights;
    }

    public double weights(int i) {
        this.loadArrays();
        return this.sampleLists == null || this.sampleLists.weights == null ? Double.NaN : this.sampleLists.weights[i];
    }

    private void loadArrays() {
        if (this.sampleLists == null) {
            this.sampleLists = this.sketch_.getSamplesAsArrays();
        }
    }

    public class VarOptItemsIterator
    implements Iterator<WeightedSample> {
        int currIdx_;
        int finalIdx_;
        final /* synthetic */ VarOptItemsSamples this$0;

        VarOptItemsIterator(VarOptItemsSamples this$0) {
            VarOptItemsSamples varOptItemsSamples = this$0;
            Objects.requireNonNull(varOptItemsSamples);
            this.this$0 = varOptItemsSamples;
            this.currIdx_ = this$0.h_ == 0 ? 1 : 0;
            int k = this$0.sketch_.getK();
            this.finalIdx_ = (int)(this$0.n_ <= (long)k ? this$0.n_ - 1L : (long)k);
        }

        VarOptItemsIterator(VarOptItemsSamples this$0, boolean useRRegion) {
            VarOptItemsSamples varOptItemsSamples = this$0;
            Objects.requireNonNull(varOptItemsSamples);
            this.this$0 = varOptItemsSamples;
            if (useRRegion) {
                this.currIdx_ = this$0.h_ + 1;
                this.finalIdx_ = this$0.sketch_.getNumSamples();
            } else {
                this.currIdx_ = 0;
                this.finalIdx_ = this$0.h_ - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currIdx_ <= this.finalIdx_;
        }

        @Override
        public WeightedSample next() {
            if (this.this$0.n_ != this.this$0.sketch_.getN()) {
                throw new ConcurrentModificationException();
            }
            if (this.currIdx_ > this.finalIdx_) {
                throw new NoSuchElementException();
            }
            int tgt = this.currIdx_++;
            if (this.currIdx_ == this.this$0.h_ && (long)this.this$0.h_ != this.this$0.n_) {
                ++this.currIdx_;
            }
            return new WeightedSample(this.this$0, tgt);
        }
    }

    class WeightCorrectingRRegionIterator
    extends VarOptItemsIterator {
        private double cumWeight;
        final /* synthetic */ VarOptItemsSamples this$0;

        WeightCorrectingRRegionIterator(VarOptItemsSamples this$0) {
            VarOptItemsSamples varOptItemsSamples = this$0;
            Objects.requireNonNull(varOptItemsSamples);
            this.this$0 = varOptItemsSamples;
            super(this$0, true);
            this.cumWeight = 0.0;
        }

        @Override
        public WeightedSample next() {
            WeightedSample sample;
            int tgt;
            if (this.this$0.n_ != this.this$0.sketch_.getN()) {
                throw new ConcurrentModificationException();
            }
            if (this.currIdx_ > this.finalIdx_) {
                throw new NoSuchElementException();
            }
            if ((tgt = this.currIdx_++) == this.finalIdx_) {
                sample = new WeightedSample(this.this$0, tgt, this.this$0.sketch_.getTotalWtR() - this.cumWeight);
            } else {
                sample = new WeightedSample(this.this$0, tgt);
                this.cumWeight += this.this$0.rWeight_;
            }
            return sample;
        }
    }

    public final class WeightedSample {
        private final int idx_;
        private double adjustedWeight_;
        final /* synthetic */ VarOptItemsSamples this$0;

        WeightedSample(VarOptItemsSamples this$0, int i) {
            VarOptItemsSamples varOptItemsSamples = this$0;
            Objects.requireNonNull(varOptItemsSamples);
            this.this$0 = varOptItemsSamples;
            this.idx_ = i;
            this.adjustedWeight_ = Double.NaN;
        }

        WeightedSample(VarOptItemsSamples this$0, int i, double adjustedWeight) {
            VarOptItemsSamples varOptItemsSamples = this$0;
            Objects.requireNonNull(varOptItemsSamples);
            this.this$0 = varOptItemsSamples;
            this.idx_ = i;
            this.adjustedWeight_ = adjustedWeight;
        }

        public T getItem() {
            return this.this$0.sketch_.getItem(this.idx_);
        }

        public double getWeight() {
            if (this.idx_ > this.this$0.h_) {
                return Double.isNaN(this.adjustedWeight_) ? this.this$0.rWeight_ : this.adjustedWeight_;
            }
            return this.this$0.sketch_.getWeight(this.idx_);
        }

        boolean getMark() {
            return this.this$0.sketch_.getMark(this.idx_);
        }
    }
}

