/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MemoryWriteToTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void testOnHeapBytes() throws IOException {
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(7));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(1023));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(10000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0x500000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0x50000A));
    }

    @Test
    public void testOnHeapInts() throws IOException {
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(7));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(1023));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(10000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0x500000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0x50000A));
    }

    @Test
    public void testOffHeap() throws Exception {
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)0x50000AL, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            MemoryWriteToTest.testWriteTo(mem.region(0L, 0L));
            MemoryWriteToTest.testOffHeap(mem, 7);
            MemoryWriteToTest.testOffHeap(mem, 1023);
            MemoryWriteToTest.testOffHeap(mem, 10000);
            MemoryWriteToTest.testOffHeap(mem, 0x500000);
            MemoryWriteToTest.testOffHeap(mem, 0x50000A);
        }
    }

    private static void testOffHeap(WritableMemory mem, int size) throws IOException {
        MemoryWriteToTest.createRandomBytesMemory(size).copyTo(0L, mem, 0L, (long)size);
        MemoryWriteToTest.testWriteTo(mem.region(0L, (long)size));
    }

    private static Memory createRandomBytesMemory(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Memory.wrap((byte[])bytes);
    }

    private static Memory createRandomIntsMemory(int size) {
        int[] ints = ThreadLocalRandom.current().ints(size).toArray();
        return Memory.wrap((int[])ints);
    }

    private static void testWriteTo(Memory mem) throws IOException {
        int cap = (int)mem.getCapacity();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(cap);
        mem.writeToByteStream(0L, cap, baos);
        byte[] result = baos.toByteArray();
        Assert.assertTrue((boolean)mem.equalTo(0L, (Resource)Memory.wrap((byte[])result), 0L, (long)cap));
        byte[] barr = new byte[cap];
        mem.getByteArray(0L, barr, 0, cap);
        Assert.assertEquals((byte[])barr, (byte[])result);
    }
}

