/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.pig.hll.SketchToEstimate;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToEstimateTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        SketchToEstimate func = new SketchToEstimate();
        Double result = (Double)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        SketchToEstimate func = new SketchToEstimate();
        Double result = (Double)func.exec(tupleFactory.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        SketchToEstimate func = new SketchToEstimate();
        HllSketch sketch = new HllSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        Double result = (Double)func.exec(tupleFactory.newTuple((Object)new DataByteArray(sketch.toCompactByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0, (double)0.01);
    }
}

