/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.GetRank;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetRankTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetRank func = new GetRank();
        KllFloatsSketch sketch = new KllFloatsSketch();
        Double result = (Double)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), Float.valueOf(0.0f))));
        Assert.assertEquals((double)result, (double)Double.NaN);
    }

    @Test
    public void normalCase() throws Exception {
        GetRank func = new GetRank();
        KllFloatsSketch sketch = new KllFloatsSketch();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        sketch.update(4.0f);
        Double result = (Double)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), Float.valueOf(3.0f))));
        Assert.assertEquals((double)result, (double)0.5);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetRank func = new GetRank();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetRank func = new GetRank();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForValue() throws Exception {
        GetRank func = new GetRank();
        KllFloatsSketch sketch = new KllFloatsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 1)));
    }
}

