/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.List;
import org.apache.datasketches.pig.sampling.ReservoirSampling;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirSamplingTest {
    @Test
    public void invalidKTest() {
        try {
            new ReservoirSampling("1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ReservoirSampling.Initial("1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ReservoirSampling.IntermediateFinal("1");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void accumulateTest() throws IOException {
        int k = 32;
        long n = 24L;
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (long i = 0L; i < 24L; ++i) {
            Tuple t = tf.newTuple(2);
            t.set(0, (Object)i);
            t.set(1, (Object)Long.toString(-i));
            inputBag.add(t);
        }
        Tuple input = tf.newTuple((Object)inputBag);
        ReservoirSampling rs = new ReservoirSampling(Integer.toString(32));
        rs.accumulate(input);
        Tuple result = rs.getValue();
        Assert.assertEquals((int)result.size(), (int)3, (String)"Incorrect output size");
        Assert.assertEquals((Object)result.get(0), (Object)24L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)24L);
        rs.accumulate(input);
        result = rs.getValue();
        Assert.assertEquals((Object)result.get(0), (Object)48L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)Math.min(32L, 48L));
        rs.cleanup();
        rs.accumulate(null);
        Assert.assertNull((Object)rs.getValue());
    }

    @Test
    public void execTest() throws IOException {
        int k = 32;
        long n = 24L;
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (long i = 0L; i < 24L; ++i) {
            Tuple t = tf.newTuple(2);
            t.set(0, (Object)i);
            t.set(1, (Object)Long.toString(-i));
            inputBag.add(t);
        }
        Tuple input = tf.newTuple((Object)inputBag);
        ReservoirSampling rs = new ReservoirSampling(Integer.toString(32));
        Tuple result = rs.exec(input);
        Assert.assertEquals((int)result.size(), (int)3, (String)"Incorrect output size");
        Assert.assertEquals((Object)result.get(0), (Object)24L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)24L);
        for (long i = 24L; i < 48L; ++i) {
            Tuple t = tf.newTuple(2);
            t.set(0, (Object)i);
            t.set(1, (Object)Long.toString(-i));
            inputBag.add(t);
        }
        result = rs.exec(input);
        Assert.assertEquals((Object)result.get(0), (Object)48L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)Math.min(32L, 48L));
    }

    @Test
    public void initialExec() throws IOException {
        int k = 32;
        long n1 = 16L;
        long n2 = 64L;
        ReservoirSampling.Initial rs = new ReservoirSampling.Initial(Integer.toString(32));
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (long i = 0L; i < 16L; ++i) {
            Tuple t = tf.newTuple(2);
            t.set(0, (Object)i);
            t.set(1, (Object)Long.toString(-i));
            inputBag.add(t);
        }
        Tuple input = tf.newTuple((Object)inputBag);
        Tuple result = rs.exec(input);
        Assert.assertEquals((int)result.size(), (int)3, (String)"Incorrect output size");
        Assert.assertEquals((Object)result.get(0), (Object)16L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)16L);
        for (long i = 16L; i < 64L; ++i) {
            Tuple t = tf.newTuple(2);
            t.set(0, (Object)i);
            t.set(1, (Object)Long.toString(-i));
            inputBag.add(t);
        }
        result = rs.exec(input);
        Assert.assertEquals((int)result.size(), (int)3, (String)"Incorrect output size");
        Assert.assertEquals((Object)result.get(0), (Object)64L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)32, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)32L);
    }

    @Test
    public void intermediateFinalExec() throws IOException {
        int maxK = 128;
        ReservoirSampling.IntermediateFinal rs = new ReservoirSampling.IntermediateFinal(Integer.toString(128));
        DataBag bagOfReservoirs = BagFactory.getInstance().newDefaultBag();
        Tuple t = TupleFactory.getInstance().newTuple(3);
        t.set(0, (Object)32L);
        t.set(1, (Object)128);
        t.set(2, (Object)ReservoirSamplingTest.generateDataBag(32L, 0));
        bagOfReservoirs.add(t);
        t = TupleFactory.getInstance().newTuple(3);
        t.set(0, (Object)64L);
        t.set(1, (Object)256);
        t.set(2, (Object)ReservoirSamplingTest.generateDataBag(64L, 32));
        bagOfReservoirs.add(t);
        t = TupleFactory.getInstance().newTuple(3);
        t.set(0, (Object)256L);
        t.set(1, (Object)128);
        t.set(2, (Object)ReservoirSamplingTest.generateDataBag(128L, 96));
        bagOfReservoirs.add(t);
        Tuple input = TupleFactory.getInstance().newTuple(1);
        input.set(0, (Object)bagOfReservoirs);
        Tuple result = (Tuple)rs.exec(input);
        long tgtN = 352L;
        int tgtMaxVal = 224;
        Assert.assertEquals((int)result.size(), (int)3, (String)"Incorrect output size");
        Assert.assertEquals((Object)result.get(0), (Object)352L, (String)"Incorrect number of samples seen");
        Assert.assertEquals((Object)result.get(1), (Object)128, (String)"Incorrect value of k");
        Assert.assertEquals((long)((DataBag)result.get(2)).size(), (long)128L);
        for (Tuple sample : (DataBag)result.get(2)) {
            int val = (Integer)sample.get(0);
            if (val >= 0 && val < 224) continue;
            Assert.fail((String)("Found value (" + val + ") outside target range [0, " + 224 + "]"));
        }
    }

    @Test
    public void outputSchemaTest() throws IOException {
        ReservoirSampling rs = new ReservoirSampling("5");
        Schema recordSchema = new Schema();
        recordSchema.add(new Schema.FieldSchema("field1", 55));
        recordSchema.add(new Schema.FieldSchema("field2", 10));
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("record", recordSchema, 110));
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("data", tupleSchema, 120));
        Schema output = rs.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        List outputFields = output.getField((int)0).schema.getFields();
        Assert.assertEquals((int)outputFields.size(), (int)3);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)0)).alias, (String)"n");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)0)).type, (byte)15);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)1)).alias, (String)"k");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)1)).type, (byte)10);
        Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)2)).alias, (String)"samples");
        Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)2)).type, (byte)120);
        Schema sampleSchema = ((Schema.FieldSchema)outputFields.get((int)2)).schema;
        Assert.assertTrue((boolean)sampleSchema.equals((Object)tupleSchema));
    }

    @Test
    public void degenerateAccumulateInput() {
        ReservoirSampling rs = new ReservoirSampling("256");
        try {
            rs.accumulate(null);
            Tuple input = TupleFactory.getInstance().newTuple(0);
            rs.accumulate(input);
            input = TupleFactory.getInstance().newTuple(1);
            input.set(0, null);
            rs.accumulate(input);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
    }

    @Test
    public void degenerateExecInput() {
        ReservoirSampling rs = new ReservoirSampling("256");
        try {
            rs.exec(null);
            Tuple input = TupleFactory.getInstance().newTuple(0);
            rs.exec(input);
            input = TupleFactory.getInstance().newTuple(1);
            input.set(0, null);
            rs.exec(input);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
    }

    @Test
    public void degenerateInitialInput() {
        try {
            ReservoirSampling.Initial rs = new ReservoirSampling.Initial("256");
            rs.exec(null);
            Tuple input = TupleFactory.getInstance().newTuple(0);
            rs.exec(input);
            input = TupleFactory.getInstance().newTuple(1);
            input.set(0, null);
            rs.exec(input);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
    }

    @Test
    public void degenerateIntermediateFinalInput() {
        try {
            ReservoirSampling.IntermediateFinal rs = new ReservoirSampling.IntermediateFinal("256");
            rs.exec(null);
            Tuple input = TupleFactory.getInstance().newTuple(0);
            rs.exec(input);
            input = TupleFactory.getInstance().newTuple(1);
            input.set(0, null);
            rs.exec(input);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
    }

    @Test
    public void degenerateSchemaTest() {
        ReservoirSampling rs = new ReservoirSampling("5");
        Schema output = rs.outputSchema(null);
        Assert.assertNull((Object)output);
        output = rs.outputSchema(new Schema());
        Assert.assertNull((Object)output);
    }

    static DataBag generateDataBag(long numItems, int startIdx) {
        DataBag output = BagFactory.getInstance().newDefaultBag();
        try {
            int i = 0;
            while ((long)i < numItems) {
                Tuple t = TupleFactory.getInstance().newTuple(2);
                int val = startIdx + i;
                t.set(0, (Object)val);
                t.set(1, (Object)Integer.toString(-val));
                output.add(t);
                ++i;
            }
        }
        catch (ExecException e) {
            Assert.fail((String)e.getMessage());
        }
        return output;
    }
}

