/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.SketchToString;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToStringTest {
    @Test
    public void testNullEmpty() throws IOException {
        SketchToString func = new SketchToString("false");
        Tuple dataTuple = null;
        String result = (String)func.exec(dataTuple);
        Assert.assertNull((Object)result);
        dataTuple = TupleFactory.getInstance().newTuple(0);
        result = (String)func.exec(dataTuple);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testExactNoDetail() throws IOException {
        SketchToString func = new SketchToString("false");
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 0, 64));
        String result = (String)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("SUMMARY"));
        Assert.assertFalse((boolean)result.contains("SKETCH DATA DETAIL"));
    }

    @Test
    public void testExactNoDetailWithSeed() throws IOException {
        SketchToString func = new SketchToString("false", Long.toString(9001L));
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 0, 64));
        String result = (String)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("SUMMARY"));
        Assert.assertFalse((boolean)result.contains("SKETCH DATA DETAIL"));
    }

    @Test
    public void testExactWithDetail() throws IOException {
        SketchToString func = new SketchToString("true");
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 0, 64));
        String result = (String)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("SUMMARY"));
        Assert.assertTrue((boolean)result.contains("SKETCH DATA DETAIL"));
    }

    @Test
    public void printlnTest() {
        SketchToStringTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

